/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactTransformer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.PathTokenizer;

public class ExplodedArtifactTransformer
implements ArtifactTransformer<ArtifactId> {
    private static final ExplodedArtifactTransformer INSTANCE = new ExplodedArtifactTransformer();
    static final int BUFFER_SIZE = 4096;

    public static <T extends ArtifactId> ArtifactTransformer<T> getInstance() {
        return INSTANCE;
    }

    public void transform(ArtifactId artifactId, InputStream is, VirtualFile target) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        ExplodedArtifactTransformer.unjar(jis, target.getPhysicalFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unjar(JarInputStream jis, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!destDir.isDirectory()) {
            throw new IOException("Destination must be a directory.");
        }
        HashSet<File> createdDirs = new HashSet<File>();
        ZipEntry zipEntry = jis.getNextEntry();
        while (zipEntry != null) {
            boolean valid = true;
            File current = destDir;
            String name = ExplodedArtifactTransformer.getName(zipEntry);
            List tokens = PathTokenizer.getTokens((String)name);
            Iterator it = tokens.iterator();
            while (it.hasNext()) {
                String token = (String)it.next();
                if (PathTokenizer.isCurrentToken((String)token) || PathTokenizer.isReverseToken((String)token)) {
                    valid = false;
                    break;
                }
                current = new File(current, token);
                if (!it.hasNext() && !zipEntry.isDirectory() || !createdDirs.add(current)) continue;
                current.mkdir();
            }
            if (valid && !zipEntry.isDirectory()) {
                FileOutputStream os = new FileOutputStream(current);
                try {
                    int len = 0;
                    byte[] buffer = new byte[4096];
                    while ((len = jis.read(buffer, 0, buffer.length)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    os.flush();
                    os.close();
                    current.setLastModified(zipEntry.getTime());
                }
                finally {
                    VFSUtils.safeClose((Closeable)os);
                }
            }
            jis.closeEntry();
            zipEntry = jis.getNextEntry();
        }
        Manifest mf = jis.getManifest();
        if (mf != null) {
            File file = new File(destDir, "META-INF/MANIFEST.MF");
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream os = new FileOutputStream(file);
            try {
                mf.write(os);
                os.flush();
                ((OutputStream)os).close();
            }
            finally {
                VFSUtils.safeClose((Closeable)os);
            }
        }
    }

    static String getName(ZipEntry entry) {
        String fileName = entry.getName();
        if (fileName.charAt(fileName.length() - 1) == '/') {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        if (fileName.charAt(0) == '/') {
            fileName = fileName.substring(1);
        }
        if (File.separatorChar != '/') {
            fileName = fileName.replace('/', File.separatorChar);
        }
        return fileName;
    }
}

