/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEServer;
import org.jboss.management.j2ee.JVM;
import org.jboss.management.j2ee.LocalJBossServerDomainMBean;
import org.jboss.management.j2ee.factory.DefaultManagedObjectFactoryMap;
import org.jboss.management.j2ee.factory.ManagedObjectFactory;
import org.jboss.management.j2ee.factory.ManagedObjectFactoryMap;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceMBeanSupport;

public class LocalJBossServerDomain
extends ServiceMBeanSupport
implements NotificationListener,
LocalJBossServerDomainMBean {
    private static final Logger log = Logger.getLogger(LocalJBossServerDomain.class);
    private J2EEDomain serverDomain;
    private ObjectName mainDeployer;
    private ObjectName sarDeployer;
    private ObjectName earDeployer;
    private ObjectName ejbDeployer;
    private ObjectName rarDeployer;
    private ObjectName jcaCMDeployer;
    private ObjectName warDeployer;
    private ObjectName carDeployer;
    private ObjectName jmsService;
    private ObjectName jndiService;
    private ObjectName jtaService;
    private ObjectName userTxService;
    private ObjectName mailService;
    private ObjectName rmiiiopService;
    private ObjectName jndiBindingService;
    private ManagedObjectFactoryMap managedObjFactoryMap;
    private Class managedObjFactoryMapClass = DefaultManagedObjectFactoryMap.class;

    public ObjectName getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(ObjectName name) {
        this.mainDeployer = name;
    }

    public ObjectName getSARDeployer() {
        return this.sarDeployer;
    }

    public void setSARDeployer(ObjectName name) {
        this.sarDeployer = name;
    }

    public ObjectName getEARDeployer() {
        return this.earDeployer;
    }

    public void setEARDeployer(ObjectName name) {
        this.earDeployer = name;
    }

    public ObjectName getEJBDeployer() {
        return this.ejbDeployer;
    }

    public void setEJBDeployer(ObjectName name) {
        this.ejbDeployer = name;
    }

    public ObjectName getRARDeployer() {
        return this.rarDeployer;
    }

    public void setRARDeployer(ObjectName name) {
        this.rarDeployer = name;
    }

    public ObjectName getCMDeployer() {
        return this.jcaCMDeployer;
    }

    public void setCMDeployer(ObjectName name) {
        this.jcaCMDeployer = name;
    }

    public ObjectName getWARDeployer() {
        return this.warDeployer;
    }

    public void setWARDeployer(ObjectName name) {
        this.warDeployer = name;
    }

    public ObjectName getCARDeployer() {
        return this.carDeployer;
    }

    public void setCARDeployer(ObjectName name) {
        this.carDeployer = name;
    }

    public ObjectName getJMSService() {
        return this.jmsService;
    }

    public void setJMSService(ObjectName name) {
        this.jmsService = name;
    }

    public ObjectName getJNDIService() {
        return this.jndiService;
    }

    public void setJNDIService(ObjectName name) {
        this.jndiService = name;
    }

    public ObjectName getJTAService() {
        return this.jtaService;
    }

    public void setJTAService(ObjectName name) {
        this.jtaService = name;
    }

    public ObjectName getMailService() {
        return this.mailService;
    }

    public void setMailService(ObjectName name) {
        this.mailService = name;
    }

    public ObjectName getUserTransactionService() {
        return this.userTxService;
    }

    public void setUserTransactionService(ObjectName name) {
        this.userTxService = name;
    }

    public ObjectName getRMI_IIOPService() {
        return this.rmiiiopService;
    }

    public void setRMI_IIOPService(ObjectName name) {
        this.rmiiiopService = name;
    }

    public ObjectName getJndiBindingService() {
        return this.jndiBindingService;
    }

    public void setJndiBindingService(ObjectName name) {
        this.jndiBindingService = name;
    }

    public Class getManagementObjFactoryMapClass() {
        return this.managedObjFactoryMapClass;
    }

    public void setManagementObjFactoryMapClass(Class cls) {
        this.managedObjFactoryMapClass = cls;
    }

    public void handleNotification(Notification msg, Object handback) {
        MBeanServer mbeanServer = this.getServer();
        if (this.managedObjFactoryMap == null || mbeanServer == null) {
            return;
        }
        log.debug((Object)("handleNotification: " + msg));
        String type = msg.getType();
        Object userData = msg.getUserData();
        try {
            ManagedObjectFactory factory;
            if (type.equals("org.jboss.system.ServiceMBean.create")) {
                ManagedObjectFactory factory2 = this.managedObjFactoryMap.getFactory(msg);
                if (factory2 != null) {
                    factory2.create(mbeanServer, userData);
                }
            } else if (type.equals("org.jboss.system.ServiceMBean.destroy") && (factory = this.managedObjFactoryMap.getFactory(msg)) != null) {
                factory.destroy(mbeanServer, userData);
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Failed to handle event", t);
        }
    }

    public String toString() {
        return "LocalJBossServerDomain { " + super.toString() + " } []";
    }

    public void createService() throws Exception {
        MBeanServer server = this.getServer();
        this.setupJ2EEMBeans(server);
        this.registerWithController(server);
        this.populateFactoryMap();
        this.registerWithCurrentDeployers(server);
    }

    protected void destroyService() throws Exception {
        MBeanServer server = this.getServer();
        this.unregisterWithCurrentDeployers(server);
        this.cleanupLeftoverMBeans(server);
        this.unregisterWithController(server);
    }

    protected void registerWithDeployer(ObjectName deployerName) {
        log.debug((Object)("Registering as listener of deployer: " + deployerName));
        try {
            this.getServer().addNotificationListener(deployerName, this, null, null);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to register with deployer: " + deployerName), (Throwable)e);
        }
    }

    protected void unregisterWithDeployer(ObjectName deployerName) {
        log.debug((Object)("Unregistering as listener of deployer: " + deployerName));
        try {
            this.getServer().removeNotificationListener(deployerName, this);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to unregister with deployer: " + deployerName), (Throwable)e);
        }
    }

    private void populateFactoryMap() throws Exception {
        this.managedObjFactoryMap = (ManagedObjectFactoryMap)this.managedObjFactoryMapClass.newInstance();
        this.managedObjFactoryMap.setSARDeployer(this.sarDeployer);
        this.managedObjFactoryMap.setEARDeployer(this.earDeployer);
        this.managedObjFactoryMap.setEJBDeployer(this.ejbDeployer);
        this.managedObjFactoryMap.setRARDeployer(this.rarDeployer);
        this.managedObjFactoryMap.setCMDeployer(this.jcaCMDeployer);
        this.managedObjFactoryMap.setWARDeployer(this.warDeployer);
        this.managedObjFactoryMap.setJMSResource(this.jmsService);
        this.managedObjFactoryMap.setJNDIResource(this.jndiService);
        this.managedObjFactoryMap.setJTAResource(this.jtaService);
        this.managedObjFactoryMap.setJTAResource(this.userTxService);
        this.managedObjFactoryMap.setJavaMailResource(this.mailService);
        this.managedObjFactoryMap.setRMI_IIOPResource(this.rmiiiopService);
    }

    private void setupJ2EEMBeans(MBeanServer mbeanServer) {
        try {
            log.debug((Object)"setupJ2EEMBeans(), create J2EEServer instance");
            Package pkg = Package.getPackage("org.jboss");
            String vendor = pkg.getSpecificationVendor();
            String version = pkg.getImplementationVersion();
            this.serverDomain = new J2EEDomain(this.serviceName.getDomain());
            ObjectName domain = this.serverDomain.getObjectName();
            mbeanServer.registerMBean(this.serverDomain, domain);
            J2EEServer j2eeServer = new J2EEServer("Local", domain, vendor, version);
            ObjectName lServer = j2eeServer.getObjectName();
            mbeanServer.registerMBean(j2eeServer, lServer);
            String hostName = "localhost";
            try {
                InetAddress lLocalHost = InetAddress.getLocalHost();
                hostName = lLocalHost.getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
            String vmVendor = System.getProperty("java.vendor");
            String vmVersion = System.getProperty("java.version");
            String name = vmVendor + " " + vmVersion;
            JVM jvm = new JVM(name, lServer, vmVersion, vmVendor, hostName);
            ObjectName jvmName = jvm.getObjectName();
            mbeanServer.registerMBean(jvm, jvmName);
        }
        catch (JMException jme) {
            log.debug((Object)"setupJ2EEMBeans - unexpected JMException", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"setupJ2EEMBeans - unexpected exception", (Throwable)e);
        }
    }

    private void registerWithController(MBeanServer mbeanServer) {
        try {
            mbeanServer.addNotificationListener(ServiceControllerMBean.OBJECT_NAME, this, null, null);
            log.debug((Object)("Registered as listener of: " + ServiceControllerMBean.OBJECT_NAME));
        }
        catch (JMException jme) {
            log.debug((Object)"unexpected exception", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"unexpected exception", (Throwable)e);
        }
    }

    private void unregisterWithController(MBeanServer mbeanServer) {
        try {
            mbeanServer.removeNotificationListener(ServiceControllerMBean.OBJECT_NAME, this);
            log.debug((Object)("UNRegistered as listener of: " + ServiceControllerMBean.OBJECT_NAME));
        }
        catch (JMException jme) {
            log.debug((Object)"unexpected exception", (Throwable)jme);
        }
        catch (Exception e) {
            log.debug((Object)"unexpected exception", (Throwable)e);
        }
    }

    private void registerWithCurrentDeployers(MBeanServer mbeanServer) throws Exception {
        log.debug((Object)("Registering with all deployers, mainDeployer=" + this.mainDeployer));
        mbeanServer.addNotificationListener(this.mainDeployer, this, null, null);
        log.debug((Object)"Getting current deployers");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Collection deployers = (Collection)mbeanServer.invoke(this.mainDeployer, "listDeployers", args, sig);
        for (ObjectName name : deployers) {
            this.registerWithDeployer(name);
        }
    }

    private void unregisterWithCurrentDeployers(MBeanServer mbeanServer) throws Exception {
        log.debug((Object)("Unregistering with all deployers, mainDeployer=" + this.mainDeployer));
        mbeanServer.removeNotificationListener(this.mainDeployer, this);
        log.debug((Object)"Getting current deployers");
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        Collection deployers = (Collection)mbeanServer.invoke(this.mainDeployer, "listDeployers", args, sig);
        for (ObjectName name : deployers) {
            this.unregisterWithDeployer(name);
        }
    }

    private void cleanupLeftoverMBeans(MBeanServer mbeanServer) throws Exception {
        String domain = this.serviceName.getDomain();
        ObjectName domainName = new ObjectName(domain + ":*");
        Set<ObjectName> domainNames = mbeanServer.queryNames(domainName, null);
        log.debug((Object)("Found " + domainNames.size() + " domain mbeans"));
        Iterator<ObjectName> domainIter = domainNames.iterator();
        while (domainIter.hasNext()) {
            try {
                ObjectName name = domainIter.next();
                if (name.equals(this.serviceName)) continue;
                this.server.unregisterMBean(name);
            }
            catch (MBeanException ignore) {}
        }
    }
}

