/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.config.BaseSecurityInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JASPIAuthenticationInfo
extends BaseAuthenticationInfo {
    List<LoginModuleStackHolder> loginModuleStack = Collections.synchronizedList(new ArrayList());

    public JASPIAuthenticationInfo() {
    }

    public JASPIAuthenticationInfo(String name) {
        super(name);
    }

    @Override
    public void add(LoginModuleStackHolder lmsHolder) {
        this.loginModuleStack.add(lmsHolder);
    }

    @Override
    public void add(AuthModuleEntry ame) {
        this.moduleEntries.add(ame);
    }

    public AuthModuleEntry[] getAuthModuleEntry() {
        AuthModuleEntry[] entries = new AuthModuleEntry[this.moduleEntries.size()];
        this.moduleEntries.toArray(entries);
        return entries;
    }

    public LoginModuleStackHolder getLoginModuleStackHolder(String name) {
        for (LoginModuleStackHolder holder : this.loginModuleStack) {
            if (!holder.getName().equals(name)) continue;
            return holder;
        }
        return null;
    }

    public LoginModuleStackHolder[] getLoginModuleStackHolder() {
        LoginModuleStackHolder[] lmshArr = new LoginModuleStackHolder[this.loginModuleStack.size()];
        this.loginModuleStack.toArray(lmshArr);
        return lmshArr;
    }

    public LoginModuleStackHolder removeLoginModuleStackHolder(String name) {
        Iterator<LoginModuleStackHolder> it = this.loginModuleStack.iterator();
        while (it.hasNext()) {
            LoginModuleStackHolder holder = it.next();
            if (!holder.getName().equals(name)) continue;
            it.remove();
            return holder;
        }
        return null;
    }

    public void copy(JASPIAuthenticationInfo pc) {
        this.loginModuleStack.addAll(pc.loginModuleStack);
        this.moduleEntries.addAll(pc.moduleEntries);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry() {
        if (this.loginModuleStack.size() > 0) {
            return this.loginModuleStack.get(0).getAppConfigurationEntry();
        }
        return new AppConfigurationEntry[0];
    }

    @Override
    public AppConfigurationEntry[] copyAppConfigurationEntry() {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (AppConfigurationEntry entry : this.getAppConfigurationEntry()) {
            entries.add(entry);
        }
        return super.copyAppConfigurationEntry(entries);
    }

    @Override
    protected BaseSecurityInfo<Object> create(String name) {
        return new JASPIAuthenticationInfo(name);
    }

    @Override
    public BaseSecurityInfo<Object> merge(BaseSecurityInfo<Object> bi) {
        if (!(bi instanceof JASPIAuthenticationInfo)) {
            throw new IllegalArgumentException("Base policy does not contain a JASPI authentication configuration");
        }
        JASPIAuthenticationInfo merged = (JASPIAuthenticationInfo)super.merge(bi);
        JASPIAuthenticationInfo parent = (JASPIAuthenticationInfo)bi;
        for (LoginModuleStackHolder holder : parent.getLoginModuleStackHolder()) {
            merged.add(holder);
        }
        for (LoginModuleStackHolder holder : this.getLoginModuleStackHolder()) {
            merged.add(holder);
        }
        return merged;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("AuthModuleEntry[]:\n");
        for (int i = 0; i < this.moduleEntries.size(); ++i) {
            AuthModuleEntry entry = (AuthModuleEntry)this.moduleEntries.get(i);
            buffer.append("[" + i + "]");
            buffer.append("\nAuthModule Class: " + entry.getAuthModuleName());
            buffer.append("\nOptions:");
            Map<String, Object> options = entry.getOptions();
            for (Map.Entry<String, Object> optionsEntry : options.entrySet()) {
                buffer.append("name=" + optionsEntry.getKey());
                buffer.append(", value=" + optionsEntry.getValue());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

