/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.lang.reflect;

import java.lang.reflect.Field;
import org.jboss.injection.lang.reflect.AbstractAccessibleObjectBeanProperty;
import org.jboss.logging.Logger;

public class FieldBeanProperty
extends AbstractAccessibleObjectBeanProperty<Field> {
    private static final Logger log = Logger.getLogger(FieldBeanProperty.class);

    public FieldBeanProperty(Field field) {
        super(field);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getField().getDeclaringClass();
    }

    protected Field getField() {
        return (Field)this.getAccessibleObject();
    }

    @Override
    public String getName() {
        return this.getField().getName();
    }

    @Override
    public Class<?> getType() {
        return this.getField().getType();
    }

    @Override
    public void set(Object instance, Object value) {
        Field field = this.getField();
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            log.fatal((Object)("illegal access on field " + field), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            boolean equalLoaders;
            String msg = "failed to set value " + value + " on field " + field;
            ClassLoader fieldLoader = field.getType().getClassLoader();
            ClassLoader valueLoader = value.getClass().getClassLoader();
            boolean bl = equalLoaders = fieldLoader == null && valueLoader == null ? true : fieldLoader.equals(valueLoader);
            if (!equalLoaders) {
                log.error((Object)("Field Classloader: " + fieldLoader + "\nValue ClassLoader: " + valueLoader + "\nEqual Loaders: " + equalLoaders));
                msg = msg + "; Reason: ClassLoaders of value and target are not equal";
            }
            log.error((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
    }
}

