/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer.jndi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.ejb3.singleton.deployer.jndi.Binding;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class SingletonBeanJndiBinder {
    private static Logger logger = Logger.getLogger(SingletonBeanJndiBinder.class);
    private Context context;
    private List<Binding> bindings = new ArrayList<Binding>();

    public SingletonBeanJndiBinder(Context context) {
        this(context, null);
    }

    public SingletonBeanJndiBinder(Context context, Collection<Binding> bindings) {
        this.context = context;
        if (bindings != null) {
            this.bindings.addAll(bindings);
        }
    }

    public Collection<Binding> getBindings() {
        return this.bindings;
    }

    @Start
    public void start() throws NamingException {
        for (Binding binding : this.bindings) {
            Util.rebind((Context)this.context, (String)binding.getJndiName(), (Object)binding.getObject());
        }
    }

    @Stop
    public void stop() throws NamingException {
        for (Binding binding : this.bindings) {
            try {
                Util.unbind((Context)this.context, (String)binding.getJndiName());
            }
            catch (NameNotFoundException nnfe) {
                logger.debug((Object)"***Ignoring*** NameNotFoundException during unbind in singleton bean jndi binder", (Throwable)nnfe);
            }
        }
    }
}

