/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.lang.reflect.Method;
import javassist.Modifier;
import javassist.util.proxy.RuntimeSupport;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.bytecode.ClassFileWriterContext;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistMemberFactory;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavassistFieldFactory
extends JavassistMemberFactory {
    protected static final String[] interfaceNames;
    protected static final Method[] methods;
    private static final String[] methodDescriptors;
    final JavassistFieldInfo field;
    final String className = JavassistField.class.getName() + counter.incrementAndGet();

    JavassistFieldFactory(Class<?> superClass, JavassistFieldInfo field, boolean debug) {
        super(superClass, debug);
        this.field = field;
    }

    @Override
    String getGeneratedClassName() {
        return this.className;
    }

    @Override
    String[] getInterfaceNames() {
        return interfaceNames;
    }

    @Override
    String getAccessedMember() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName() + this.field.getDescriptor();
    }

    @Override
    String initAccessedMember() {
        return null;
    }

    @Override
    boolean implementMethod(int index, ClassFileWriterContext<?> cfwc) {
        if (index >= methods.length) {
            return false;
        }
        Method method = methods[index];
        cfwc.beginMethod(1, method.getName(), methodDescriptors[index], THROWABLE_EXCEPTIONS);
        boolean isStatic = Modifier.isStatic((int)this.field.getModifiers());
        int maxLocals = 0;
        if (index == 0) {
            maxLocals = 2;
            this.makeGetMethod(cfwc, isStatic);
        } else {
            maxLocals = 3;
            this.makeSetMethod(cfwc, isStatic);
        }
        cfwc.endMethod(maxLocals);
        return true;
    }

    private void makeGetMethod(ClassFileWriterContext<?> cfwc, boolean isStatic) {
        if (isStatic) {
            cfwc.addGetStatic(ClassFileWriterContext.jvmClassName(this.field.getDeclaringClass().getName()), this.field.getName(), this.field.getDescriptor());
        } else {
            String targetClassName = ClassFileWriterContext.jvmClassName(this.field.getDeclaringClass().getName());
            cfwc.addAload(1);
            cfwc.addCheckcast(targetClassName);
            cfwc.addGetField(targetClassName, this.field.getName(), this.field.getDescriptor());
        }
        this.boxReturnValue(cfwc, this.field.getDescriptor());
        cfwc.addAReturn();
    }

    private void makeSetMethod(ClassFileWriterContext<?> cfwc, boolean isStatic) {
        if (!isStatic) {
            cfwc.addAload(1);
            cfwc.addCheckcast(ClassFileWriterContext.jvmClassName(this.field.getDeclaringClass().getName()));
        }
        cfwc.addAload(2);
        this.castAndUnbox(cfwc, this.field.getDescriptor());
        if (isStatic) {
            cfwc.addPutStatic(ClassFileWriterContext.jvmClassName(this.field.getDeclaringClass().getName()), this.field.getName(), this.field.getDescriptor());
        } else {
            cfwc.addPutField(ClassFileWriterContext.jvmClassName(this.field.getDeclaringClass().getName()), this.field.getName(), this.field.getDescriptor());
        }
        cfwc.addAReturn();
    }

    static {
        methodDescriptors = new String[2];
        interfaceNames = new String[]{JavassistField.class.getName()};
        methods = new Method[2];
        try {
            JavassistFieldFactory.methods[0] = SecurityActions.getDeclaredMethod(JavassistField.class, "get", Object.class);
            JavassistFieldFactory.methods[1] = SecurityActions.getDeclaredMethod(JavassistField.class, "set", Object.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        JavassistFieldFactory.methodDescriptors[0] = RuntimeSupport.makeDescriptor((Method)methods[0]);
        JavassistFieldFactory.methodDescriptors[1] = RuntimeSupport.makeDescriptor((Method)methods[1]);
    }
}

