/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import javassist.bytecode.SignatureAttribute;

abstract class JavassistTypeVariableSpy {
    JavassistTypeVariableSpy() {
    }

    static JavassistTypeVariableSpy createForBehavior(SignatureAttribute.ClassSignature classSig, SignatureAttribute.MethodSignature sig) {
        return new MethodTypeVariable(classSig, sig);
    }

    static JavassistTypeVariableSpy createForClass(SignatureAttribute.ClassSignature sig) {
        return new ClassTypeVariable(sig);
    }

    static JavassistTypeVariableSpy createForField(SignatureAttribute.ClassSignature sig) {
        return new ClassTypeVariable(sig);
    }

    abstract SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable var1);

    private static SignatureAttribute.Type getTypeFromTypeParameters(SignatureAttribute.TypeVariable tv, SignatureAttribute.TypeParameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(tv.getName())) continue;
            SignatureAttribute.ObjectType type = parameters[i].getClassBound();
            if (type != null) {
                return type;
            }
            SignatureAttribute.ObjectType[] types = parameters[i].getInterfaceBound();
            if (types == null || types.length <= 0) break;
            return types[0];
        }
        return null;
    }

    private static class ClassTypeVariable
    extends JavassistTypeVariableSpy {
        private final SignatureAttribute.ClassSignature sig;

        public ClassTypeVariable(SignatureAttribute.ClassSignature sig) {
            this.sig = sig;
        }

        SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable tv) {
            SignatureAttribute.Type type = JavassistTypeVariableSpy.getTypeFromTypeParameters(tv, this.sig.getParameters());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("No type parameter found called " + tv.getName() + " in " + this.sig);
        }
    }

    private static class MethodTypeVariable
    extends JavassistTypeVariableSpy {
        protected final SignatureAttribute.ClassSignature classSig;
        private final SignatureAttribute.MethodSignature sig;

        MethodTypeVariable(SignatureAttribute.ClassSignature classSig, SignatureAttribute.MethodSignature sig) {
            this.classSig = classSig;
            this.sig = sig;
        }

        SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable tv) {
            SignatureAttribute.Type type = JavassistTypeVariableSpy.getTypeFromTypeParameters(tv, this.sig.getTypeParameters());
            if (type != null) {
                return type;
            }
            type = JavassistTypeVariableSpy.getTypeFromTypeParameters(tv, this.classSig.getParameters());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("No type parameter found called " + tv.getName() + " in " + this.sig + " or in " + this.classSig);
        }
    }
}

