/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Modifier;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.JavassistAccessController;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.ModifierInfo;
import org.jboss.reflect.spi.MutableFieldInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistFieldInfo
extends JavassistAnnotatedInfo
implements MutableFieldInfo {
    private static final long serialVersionUID = -104555531831318930L;
    private final CtField ctField;
    private volatile transient JavassistField field;
    private volatile transient TypeInfo fieldType;
    protected final JavassistTypeInfo typeInfo;
    private volatile transient String name;
    private volatile transient boolean initializedModifiers;
    private volatile transient int modifiers;

    public JavassistFieldInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtField ctField) {
        super(annotationHelper);
        this.typeInfo = typeInfo;
        this.ctField = ctField;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.ctField.getName();
        }
        return this.name;
    }

    public int getModifiers() {
        if (!this.initializedModifiers) {
            this.modifiers = this.ctField.getModifiers();
            this.initializedModifiers = true;
        }
        return this.modifiers;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    public JavassistTypeInfo getDeclaringClass() {
        return this.typeInfo;
    }

    public TypeInfo getType() {
        if (this.fieldType != null) {
            return this.fieldType;
        }
        try {
            SignatureAttribute.ObjectType type = JavassistHelper.getFieldSignature(this.ctField);
            if (type != null) {
                SignatureAttribute.ClassSignature sig = this.getDeclaringClass().getClassSignature();
                this.fieldType = this.typeInfo.getFactory().getTypeInfo(this.typeInfo.getClassLoaderInternal(), (SignatureAttribute.Type)type, JavassistTypeVariableSpy.createForField(sig));
            } else {
                CtClass clazz = this.ctField.getType();
                this.fieldType = this.typeInfo.getFactory().getTypeInfo(clazz);
            }
            return this.fieldType;
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseFieldNotFound(this.getName(), e);
        }
    }

    public Object get(Object target) throws Throwable {
        JavassistAccessController.checkAccess(this);
        return this.getJavassistField().get(target);
    }

    public Object set(Object target, Object value) throws Throwable {
        JavassistAccessController.checkAccess(this);
        this.getJavassistField().set(target, value);
        return null;
    }

    private JavassistField getJavassistField() throws Throwable {
        if (this.field == null) {
            JavassistField f = JavassistReflectionFactory.INSTANCE.createField(this);
            if (this.field == null) {
                this.field = f;
            }
        }
        return this.field;
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return this.getDeclaringClass().equals(other.getDeclaringClass());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    public AnnotationValue[] getAnnotations() {
        return this.getAnnotations(this.ctField);
    }

    public CtField getCtField() {
        return this.ctField;
    }

    public void setModifier(ModifierInfo modifier) {
        this.ctField.setModifiers(modifier.getModifiers());
        this.typeInfo.clearFieldCache();
    }

    public void setName(String name) {
        this.ctField.setName(name);
        this.typeInfo.clearFieldCache();
    }

    public void setType(ClassInfo type) {
        this.ctField.setType(JavassistUtil.toCtClass(type));
        this.typeInfo.clearFieldCache();
    }

    public void setType(String type) {
        this.ctField.setType(JavassistUtil.toCtClass(this.typeInfo.getCtClass().getClassPool(), type));
        this.typeInfo.clearFieldCache();
    }

    public String getDescriptor() {
        return this.ctField.getSignature();
    }
}

