/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodePrimitive {
    public static final BytecodePrimitive BOOLEAN = new BytecodePrimitive("boolean", "Z", Boolean.class, Boolean.TYPE, "booleanValue");
    public static final BytecodePrimitive CHAR = new BytecodePrimitive("char", "C", Character.class, Character.TYPE, "charValue");
    public static final BytecodePrimitive BYTE = new BytecodePrimitive("byte", "B", Byte.class, Byte.TYPE, "byteValue");
    public static final BytecodePrimitive SHORT = new BytecodePrimitive("short", "S", Short.class, Short.TYPE, "shortValue");
    public static final BytecodePrimitive INT = new BytecodePrimitive("int", "I", Integer.class, Integer.TYPE, "intValue");
    public static final BytecodePrimitive LONG = new BytecodePrimitive("long", "J", Long.class, Long.TYPE, "longValue");
    public static final BytecodePrimitive FLOAT = new BytecodePrimitive("float", "F", Float.class, Float.TYPE, "floatValue");
    public static final BytecodePrimitive DOUBLE = new BytecodePrimitive("double", "D", Double.class, Double.TYPE, "doubleValue");
    public static final BytecodePrimitive VOID = new BytecodePrimitive("void", "V", Void.class, Void.TYPE, null);
    static final Map<String, BytecodePrimitive> primitives;
    final String name;
    final Class<?> wrapperClass;
    final Class<?> primitiveClass;
    final String arrayComponentName;
    final String wrapperClassName;
    final String valueMethodName;

    private BytecodePrimitive(String name, String arrayComponentName, Class<?> wrapperClass, Class<?> primitiveClass, String valueMethodName) {
        this.name = name;
        this.arrayComponentName = arrayComponentName;
        this.wrapperClass = wrapperClass;
        this.primitiveClass = primitiveClass;
        this.wrapperClassName = wrapperClass.getName();
        this.valueMethodName = valueMethodName;
    }

    public static BytecodePrimitive valueOf(String name) {
        return primitives.get(name);
    }

    public String getName() {
        return this.name;
    }

    public String getArrayComponentName() {
        return this.arrayComponentName;
    }

    public String getWrapperClassName() {
        return this.wrapperClassName;
    }

    public String getValueMethodName() {
        return this.valueMethodName;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperClass;
    }

    public Class<?> getPrimitiveClass() {
        return this.primitiveClass;
    }

    static {
        HashMap<String, BytecodePrimitive> map = new HashMap<String, BytecodePrimitive>();
        map.put(BOOLEAN.getName(), BOOLEAN);
        map.put(BOOLEAN.getArrayComponentName(), BOOLEAN);
        map.put(CHAR.getName(), CHAR);
        map.put(CHAR.getArrayComponentName(), CHAR);
        map.put(BYTE.getName(), BYTE);
        map.put(BYTE.getArrayComponentName(), BYTE);
        map.put(SHORT.getName(), SHORT);
        map.put(SHORT.getArrayComponentName(), SHORT);
        map.put(INT.getName(), INT);
        map.put(INT.getArrayComponentName(), INT);
        map.put(LONG.getName(), LONG);
        map.put(LONG.getArrayComponentName(), LONG);
        map.put(FLOAT.getName(), FLOAT);
        map.put(FLOAT.getArrayComponentName(), FLOAT);
        map.put(DOUBLE.getName(), DOUBLE);
        map.put(DOUBLE.getArrayComponentName(), DOUBLE);
        map.put(VOID.getName(), VOID);
        map.put(VOID.getArrayComponentName(), VOID);
        primitives = Collections.unmodifiableMap(map);
    }
}

