/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import org.jboss.reflect.plugins.bytecode.SecurityActions;

public interface ClassLoaderFinder {
    public ClassLoader getLoaderForClass(ClassLoader var1, String var2);

    public static class LoadClass
    implements ClassLoaderFinder {
        public static LoadClass INSTANCE = new LoadClass();

        private LoadClass() {
        }

        public ClassLoader getLoaderForClass(ClassLoader initiating, String name) {
            try {
                Class<?> clazz = SecurityActions.loadClass(initiating, name);
                ClassLoader loader = SecurityActions.getClassLoader(clazz);
                if (loader == null) {
                    loader = SecurityActions.getSystemClassLoader();
                }
                return loader;
            }
            catch (ClassNotFoundException e) {
                if (name.endsWith(".package-info")) {
                    return null;
                }
                throw new RuntimeException("Could not find '" + name + "' in classloader " + initiating);
            }
        }
    }

    public static class Default
    implements ClassLoaderFinder {
        public static Default INSTANCE = new Default();

        private Default() {
        }

        public ClassLoader getLoaderForClass(ClassLoader initiating, String name) {
            return initiating;
        }
    }
}

