/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.catalina;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.ContainerEventHandler;
import org.jboss.modcluster.catalina.CatalinaContext;
import org.jboss.modcluster.catalina.CatalinaEngine;
import org.jboss.modcluster.catalina.CatalinaServer;

public class CatalinaEventHandlerAdapter
implements LifecycleListener,
ContainerListener,
NotificationListener {
    private volatile ObjectName serviceObjectName = CatalinaEventHandlerAdapter.toObjectName("jboss.web:service=WebServer");
    private volatile ObjectName serverObjectName = CatalinaEventHandlerAdapter.toObjectName("jboss.web:type=Server");
    private volatile String connectorsStartedNotificationType = "jboss.tomcat.connectors.started";
    private volatile String connectorsStoppedNotificationType = "jboss.tomcat.connectors.stopped";
    private final ContainerEventHandler eventHandler;
    private final MBeanServer mbeanServer;
    private final AtomicBoolean init = new AtomicBoolean(false);
    private final AtomicBoolean start = new AtomicBoolean(false);

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler) {
        this(eventHandler, ManagementFactory.getPlatformMBeanServer());
    }

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer mbeanServer) {
        this.eventHandler = eventHandler;
        this.mbeanServer = mbeanServer;
    }

    public void start() throws JMException {
        Server server = this.findServer();
        if (server != null) {
            if (!(server instanceof Lifecycle)) {
                throw new IllegalStateException();
            }
            Lifecycle lifecycle = (Lifecycle)server;
            if (!this.containsListener(lifecycle)) {
                lifecycle.addLifecycleListener((LifecycleListener)this);
            }
            if (this.init.compareAndSet(false, true)) {
                this.init(server);
            }
            if (this.start.compareAndSet(false, true)) {
                this.eventHandler.start(new CatalinaServer(server, this.mbeanServer));
            }
        }
    }

    public void stop() throws JMException {
        Server server = this.findServer();
        if (server != null) {
            if (!(server instanceof Lifecycle)) {
                throw new IllegalStateException();
            }
            Lifecycle lifecycle = (Lifecycle)server;
            lifecycle.removeLifecycleListener((LifecycleListener)this);
            if (this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(new CatalinaServer(server, this.mbeanServer));
            }
            if (this.init.compareAndSet(true, false)) {
                this.destroy(server);
            }
        }
    }

    private boolean containsListener(Lifecycle lifecycle) {
        for (LifecycleListener listener : lifecycle.findLifecycleListeners()) {
            if (!listener.equals(this)) continue;
            return true;
        }
        return false;
    }

    private Server findServer() throws JMException {
        try {
            Service[] services = (Service[])this.mbeanServer.invoke(this.serverObjectName, "findServices", null, null);
            return services.length > 0 ? services[0].getServer() : null;
        }
        catch (InstanceNotFoundException e) {
            return null;
        }
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                if (this.start.get()) {
                    this.eventHandler.add(new CatalinaContext((Context)child, this.mbeanServer));
                }
            } else if (container instanceof Engine) {
                container.addContainerListener((ContainerListener)this);
                if (child != null) {
                    ((Host)child).addContainerListener((ContainerListener)this);
                }
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                if (this.start.get()) {
                    this.eventHandler.remove(new CatalinaContext((Context)child, this.mbeanServer));
                }
            } else if (container instanceof Engine) {
                if (child != null) {
                    ((Host)child).removeContainerListener((ContainerListener)this);
                }
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (type.equals("init")) {
            if (source instanceof Server && this.init.compareAndSet(false, true)) {
                Server server = (Server)source;
                this.init(server);
            }
        } else if (type.equals("start")) {
            if (source instanceof Context) {
                if (this.start.get()) {
                    this.eventHandler.start(new CatalinaContext((Context)source, this.mbeanServer));
                }
            } else if (source instanceof Server && this.init.compareAndSet(false, true)) {
                Server server = (Server)source;
                this.init(server);
            }
        } else if (type.equals("after_start")) {
            if (source instanceof Server && this.init.get() && this.start.compareAndSet(false, true)) {
                this.eventHandler.start(new CatalinaServer((Server)source, this.mbeanServer));
            }
        } else if (type.equals("before_stop")) {
            if (source instanceof Context) {
                if (this.start.get()) {
                    this.eventHandler.stop(new CatalinaContext((Context)source, this.mbeanServer));
                }
            } else if (source instanceof Server && this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(new CatalinaServer((Server)source, this.mbeanServer));
            }
        } else if (type.equals("destroy")) {
            if (source instanceof Server && this.init.compareAndSet(true, false)) {
                this.destroy((Server)source);
            }
        } else if (type.equals("periodic") && source instanceof Engine && this.start.get()) {
            this.eventHandler.status(new CatalinaEngine((Engine)source, this.mbeanServer));
        }
    }

    private void init(Server server) {
        this.eventHandler.init(new CatalinaServer(server, this.mbeanServer));
        this.addListeners(server);
        if (this.mbeanServer.isRegistered(this.serviceObjectName)) {
            try {
                this.mbeanServer.addNotificationListener(this.serviceObjectName, this, null, (Object)server);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void destroy(Server server) {
        this.removeListeners(server);
        if (this.mbeanServer.isRegistered(this.serviceObjectName)) {
            try {
                this.mbeanServer.removeNotificationListener(this.serviceObjectName, this);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (ListenerNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        this.eventHandler.shutdown();
    }

    private void addListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            ((Lifecycle)engine).addLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.addContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).addLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    private void removeListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            ((Lifecycle)engine).removeLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.removeContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).removeLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    public void handleNotification(Notification notification, Object object) {
        String type = notification.getType();
        if (type != null) {
            if (type.equals(this.connectorsStartedNotificationType)) {
                if (this.start.get()) {
                    for (Service service : ((Server)object).findServices()) {
                        this.eventHandler.status(new CatalinaEngine((Engine)service.getContainer(), this.mbeanServer));
                    }
                }
            } else if (type.equals(this.connectorsStoppedNotificationType) && this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(new CatalinaServer((Server)object, this.mbeanServer));
            }
        }
    }

    public void setServiceObjectName(ObjectName serviceObjectName) {
        this.serviceObjectName = serviceObjectName;
    }

    public void setServerObjectName(ObjectName serverObjectName) {
        this.serverObjectName = serverObjectName;
    }

    public void setConnectorsStoppedNotificationType(String type) {
        this.connectorsStoppedNotificationType = type;
    }

    public void setConnectorsStartedNotificationType(String type) {
        this.connectorsStartedNotificationType = type;
    }

    public int hashCode() {
        return 1;
    }

    private static ObjectName toObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

