/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins;

import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.classpool.base.BaseClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.AbstractClassPool;
import org.jboss.util.collection.ConcurrentSet;

public class NonDelegatingClassPool
extends BaseClassPool {
    private Set<String> parentBlacklist = new ConcurrentSet(100, 0.75f, 3);
    private Set<String> parentWhitelist = new ConcurrentSet(100, 0.75f, 3);

    public NonDelegatingClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean parentFirst) {
        super(cl, src, repository, AbstractClassPool.SEARCH_LOCAL_ONLY_STRATEGY);
        this.childFirstLookup = !parentFirst;
    }

    public CtClass createCtClass(String classname, boolean useCache) {
        boolean trace = this.logger.isTraceEnabled();
        CtClass clazz = null;
        if (!this.childFirstLookup) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " attempting to create " + classname + " in parent pool (parentFirst)"));
            }
            clazz = this.createParentCtClass(classname, useCache, trace);
        }
        if (clazz == null && this.isLocalResource(this.getResourceName(classname), trace)) {
            clazz = super.createCtClass(classname, useCache);
        }
        if (this.childFirstLookup && clazz == null) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " attempting to create " + classname + " in parent pool (parentLast)"));
            }
            clazz = this.createParentCtClass(classname, useCache, trace);
        }
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " created " + classname + " " + this.getClassPoolLogStringForClass(clazz)));
        }
        return clazz;
    }

    private CtClass createParentCtClass(String classname, boolean useCache, boolean trace) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BaseClassPool) {
            return ((BaseClassPool)this.parent).createCtClass(classname, useCache);
        }
        return this.plainParentGet(classname);
    }

    private CtClass plainParentGet(String classname) {
        try {
            if (this.parentWhitelist.contains(classname)) {
                return this.parent.get(classname);
            }
        }
        catch (NotFoundException e) {
            this.logger.warn((Object)(classname + " not loaded from parent despite having been loaded before"));
            return null;
        }
        if (this.parentBlacklist.contains(classname)) {
            return null;
        }
        try {
            CtClass clazz = this.parent.get(classname);
            this.parentWhitelist.add(classname);
            return clazz;
        }
        catch (NotFoundException e) {
            this.parentBlacklist.add(classname);
            return null;
        }
    }
}

