/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.exporter.ExplodedExporterDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedExporterImpl
extends AssignableBase
implements ExplodedExporter {
    private static final Logger log = Logger.getLogger(ExplodedExporterImpl.class.getName());
    private Archive<?> archive;

    public ExplodedExporterImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        this.archive = archive;
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    public File exportExploded(File baseDirectory) {
        Validate.notNull(this.archive, "No archive provided");
        Validate.notNull(baseDirectory, "No baseDirectory provided");
        if (!baseDirectory.exists()) {
            throw new IllegalArgumentException("Parent directory does not exist");
        }
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided parent directory is not a valid directory");
        }
        ExplodedExporterDelegate exporterDelegate = new ExplodedExporterDelegate(this.archive, baseDirectory);
        exporterDelegate.export();
        File explodedDirectory = exporterDelegate.getResult();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created Exploded Archive: " + explodedDirectory.getAbsolutePath());
        }
        return explodedDirectory;
    }
}

