/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnterpriseContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements EnterpriseContainer<T> {
    protected EnterpriseContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract ArchivePath getApplicationPath();

    public T setApplicationXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.setApplicationXML(new ClassLoaderAsset(resourceName));
    }

    public T setApplicationXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML((Asset)new FileAsset(resource));
    }

    public T setApplicationXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML((Asset)new UrlAsset(resource));
    }

    public T setApplicationXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(resource, "application.xml");
    }

    public T addApplicationResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addApplicationResource((Asset)new ClassLoaderAsset(resourceName), resourceName);
    }

    public T addApplicationResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addApplicationResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addApplicationResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new FileAsset(resource), target);
    }

    public T addApplicationResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new UrlAsset(resource), target);
    }

    public T addApplicationResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addApplicationResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addApplicationResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new FileAsset(resource), target);
    }

    public T addApplicationResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource((Asset)new UrlAsset(resource), target);
    }

    public T addApplicationResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getApplicationPath(), target);
        return this.add(resource, (ArchivePath)location);
    }

    public T addApplicationResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addApplicationResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addApplicationResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addApplicationResource(resourcePackage, resourceName, target);
    }

    public T addApplicationResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addApplicationResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addApplicationResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addApplicationResource((Asset)resource, target);
    }

    protected abstract ArchivePath getModulePath();

    public T addModule(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getModulePath());
    }

    public T addModule(String resourceName) {
        Validate.notNull(resourceName, "ResourceName must be specified");
        BasicPath location = new BasicPath(AssetUtil.getNameForClassloaderResource(resourceName));
        return this.addModule(resourceName, (ArchivePath)location);
    }

    public T addModule(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addModule(resource, resource.getName());
    }

    public T addModule(File resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        FileAsset asset = new FileAsset(resource);
        return this.addModule((Asset)asset, targetPath);
    }

    public T addModule(String resourceName, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        ClassLoaderAsset asset = new ClassLoaderAsset(resourceName);
        return this.addModule((Asset)asset, targetPath);
    }

    public T addModule(URL resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        UrlAsset asset = new UrlAsset(resource);
        return this.addModule((Asset)asset, targetPath);
    }

    public T addModule(File resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    public T addModule(Asset resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    public T addModule(String resourceName, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resourceName, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resourceName, (ArchivePath)new BasicPath(targetPath));
    }

    public T addModule(URL resource, String targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.addModule(resource, (ArchivePath)new BasicPath(targetPath));
    }

    public T addModule(Asset resource, ArchivePath targetPath) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(targetPath, "Target Path must be specified");
        return this.add(resource, (ArchivePath)new BasicPath(this.getModulePath(), targetPath));
    }
}

