/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.impl.manager;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.injection.manager.spi.InjectionManager;
import org.jboss.interceptor.proxy.DefaultInvocationContextFactory;
import org.jboss.interceptor.proxy.InterceptorInvocation;
import org.jboss.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.interceptor.spi.context.InterceptionChain;
import org.jboss.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.jboss.managed.bean.impl.ManagedBeanInstanceImpl;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.spi.ManagedBeanInstance;
import org.jboss.managed.bean.spi.ManagedBeanManager;

public class ManagedBeanManagerImpl<T>
implements ManagedBeanManager<T> {
    protected ManagedBeanMetaData mbMetaData;
    protected Class<T> managedBeanClass;
    private InjectionManager injectionManager;

    public ManagedBeanManagerImpl(Class<T> beanClass, ManagedBeanMetaData beanMetaData, InjectionManager injectionManager) {
        if (beanClass == null || beanMetaData == null || injectionManager == null) {
            throw new IllegalArgumentException("Neither of managed bean class " + beanClass + " ,managed bean metadata " + beanMetaData + " nor injection manager " + injectionManager + " should be null");
        }
        this.managedBeanClass = beanClass;
        this.mbMetaData = beanMetaData;
        this.injectionManager = injectionManager;
    }

    public ManagedBeanMetaData getMetadata() {
        return this.mbMetaData;
    }

    public Object invoke(ManagedBeanInstance<T> managedBeanInstance, Method method, Object[] args) throws Throwable {
        List aroundInvokeInterceptors = this.mbMetaData.getAroundInvokes(method);
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(aroundInvokeInterceptors.size());
        for (InterceptorMetadata aroundInvokeInterceptor : aroundInvokeInterceptors) {
            Object instance = null;
            if (aroundInvokeInterceptor.isTargetClass()) {
                instance = managedBeanInstance.getInstance();
            } else {
                String interceptorClassName = aroundInvokeInterceptor.getInterceptorClass().getClassName();
                instance = managedBeanInstance.getInterceptor(interceptorClassName);
            }
            InterceptorInvocation interceptorInvocation = new InterceptorInvocation(instance, aroundInvokeInterceptor, InterceptionType.AROUND_INVOKE);
            interceptorInvocations.add(interceptorInvocation);
        }
        SimpleInterceptionChain interceptorChain = new SimpleInterceptionChain(interceptorInvocations, InterceptionType.AROUND_INVOKE, managedBeanInstance.getInstance(), method);
        DefaultInvocationContextFactory invocationCtxFactory = new DefaultInvocationContextFactory();
        InvocationContext invocationCtx = invocationCtxFactory.newInvocationContext((InterceptionChain)interceptorChain, managedBeanInstance.getInstance(), method, args);
        return invocationCtx.proceed();
    }

    public ManagedBeanInstance<T> createManagedBeanInstance() throws Exception {
        T instance = this.createInstance(this.managedBeanClass);
        Collection<Object> interceptorInstances = this.createInterceptors();
        this.injectionManager.inject(instance);
        for (Object interceptorInstance : interceptorInstances) {
            this.injectionManager.inject(interceptorInstance);
        }
        ManagedBeanInstanceImpl<T> mbInstance = new ManagedBeanInstanceImpl<T>(instance, interceptorInstances);
        this.handlePostConstruct(mbInstance);
        return mbInstance;
    }

    private void handlePostConstruct(ManagedBeanInstance<T> managedBeanInstance) throws Exception {
        List postConstructs = this.mbMetaData.getPostConstructs();
        ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(postConstructs.size());
        for (InterceptorMetadata interceptor : postConstructs) {
            Object instance = null;
            if (interceptor.isTargetClass()) {
                instance = managedBeanInstance.getInstance();
            } else {
                String interceptorClassName = interceptor.getInterceptorClass().getClassName();
                instance = managedBeanInstance.getInterceptor(interceptorClassName);
            }
            InterceptorInvocation interceptorInvocation = new InterceptorInvocation(instance, interceptor, InterceptionType.POST_CONSTRUCT);
            interceptorInvocations.add(interceptorInvocation);
        }
        SimpleInterceptionChain interceptorChain = new SimpleInterceptionChain(interceptorInvocations, InterceptionType.POST_CONSTRUCT, managedBeanInstance.getInstance(), null);
        DefaultInvocationContextFactory invocationCtxFactory = new DefaultInvocationContextFactory();
        InvocationContext invocationCtx = invocationCtxFactory.newInvocationContext((InterceptionChain)interceptorChain, managedBeanInstance.getInstance(), null, null);
        invocationCtx.proceed();
    }

    private Collection<Object> createInterceptors() {
        Collection allInterceptors = this.mbMetaData.getAllInterceptors();
        ArrayList<Object> interceptorInstances = new ArrayList<Object>();
        for (InterceptorMetadata interceptor : allInterceptors) {
            String interceptorClassName = interceptor.getInterceptorClass().getClassName();
            try {
                Class<?> interceptorClass = Class.forName(interceptorClassName, false, this.managedBeanClass.getClassLoader());
                Object interceptorInstance = this.createInstance(interceptorClass);
                interceptorInstances.add(interceptorInstance);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load interceptor class: " + interceptorClassName, cnfe);
            }
        }
        return interceptorInstances;
    }

    private <I> I createInstance(Class<I> klass) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }
}

