/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceAcknowledgement;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMSequenceAcknowledgementSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMSequenceAcknowledgementSerializer();

    private RMSequenceAcknowledgementSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMSequenceAcknowledgement o = (RMSequenceAcknowledgement)object;
        try {
            QName noneQName;
            SOAPElement noneElement;
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            RMConstants wsrmConstants = provider.getConstants();
            QName sequenceAckQName = wsrmConstants.getSequenceAcknowledgementQName();
            SOAPElement sequenceAckElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapHeader, sequenceAckQName, "soap header");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(sequenceAckElement, identifierQName, sequenceAckQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
            QName finalQName = wsrmConstants.getFinalQName();
            SOAPElement finalElement = RMSerializationHelper.getOptionalElement(sequenceAckElement, finalQName, sequenceAckQName);
            if (finalElement != null) {
                o.setFinal();
            }
            if ((noneElement = RMSerializationHelper.getOptionalElement(sequenceAckElement, noneQName = wsrmConstants.getNoneQName(), sequenceAckQName)) != null) {
                o.setNone();
            }
            QName nackQName = wsrmConstants.getNackQName();
            List<SOAPElement> nackElements = RMSerializationHelper.getOptionalElements(sequenceAckElement, nackQName, sequenceAckQName);
            for (SOAPElement nackElement : nackElements) {
                String messageId = RMSerializationHelper.getRequiredTextContent(nackElement, nackQName);
                o.addNack(RMSerializationHelper.stringToLong(messageId, "Unable to parse Nack element text content"));
            }
            QName ackRangeQName = wsrmConstants.getAcknowledgementRangeQName();
            List<SOAPElement> ackRangeElements = RMSerializationHelper.getOptionalElements(sequenceAckElement, ackRangeQName, sequenceAckQName);
            if (ackRangeElements.size() != 0) {
                QName upperQName = wsrmConstants.getUpperQName();
                QName lowerQName = wsrmConstants.getLowerQName();
                for (SOAPElement ackRangeElement : ackRangeElements) {
                    RMSequenceAcknowledgement.RMAcknowledgementRange ackRange = o.newAcknowledgementRange();
                    String upper = RMSerializationHelper.getRequiredTextContent(ackRangeElement, upperQName, ackRangeQName);
                    ackRange.setUpper(RMSerializationHelper.stringToLong(upper, "Unable to parse Upper attribute text content"));
                    String lower = RMSerializationHelper.getRequiredTextContent(ackRangeElement, lowerQName, ackRangeQName);
                    ackRange.setLower(RMSerializationHelper.stringToLong(lower, "Unable to parse Lower attribute text content"));
                    o.addAcknowledgementRange(ackRange);
                }
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    @Override
    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMSequenceAcknowledgement o = (RMSequenceAcknowledgement)object;
        try {
            List<RMSequenceAcknowledgement.RMAcknowledgementRange> ackRanges;
            List<Long> nacks;
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName sequenceAckQName = wsrmConstants.getSequenceAcknowledgementQName();
            SOAPElement sequenceAckElement = soapEnvelope.getHeader().addChildElement(sequenceAckQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            sequenceAckElement.addChildElement(identifierQName).setValue(o.getIdentifier());
            if (o.isFinal()) {
                QName finalQName = wsrmConstants.getFinalQName();
                sequenceAckElement.addChildElement(finalQName);
            }
            if (o.isNone()) {
                QName noneQName = wsrmConstants.getNoneQName();
                sequenceAckElement.addChildElement(noneQName);
            }
            if ((nacks = o.getNacks()).size() != 0) {
                QName nackQName = wsrmConstants.getNackQName();
                for (Long messageId : nacks) {
                    sequenceAckElement.addChildElement(nackQName).setValue(String.valueOf(messageId));
                }
            }
            if ((ackRanges = o.getAcknowledgementRanges()).size() != 0) {
                QName acknowledgementRangeQName = wsrmConstants.getAcknowledgementRangeQName();
                QName upperQName = wsrmConstants.getUpperQName();
                QName lowerQName = wsrmConstants.getLowerQName();
                for (RMSequenceAcknowledgement.RMAcknowledgementRange ackRange : ackRanges) {
                    SOAPElement acknowledgementRangeElement = sequenceAckElement.addChildElement(acknowledgementRangeQName);
                    acknowledgementRangeElement.addAttribute(lowerQName, String.valueOf(ackRange.getLower()));
                    acknowledgementRangeElement.addAttribute(upperQName, String.valueOf(ackRange.getUpper()));
                }
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

