/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import javax.el.MethodExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.UIComponentBase;
import javax.faces.component._MethodBindingToMethodExpression;
import javax.faces.component._MethodExpressionToMethodBinding;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class UICommand
extends UIComponentBase
implements ActionSource2 {
    public static final String COMPONENT_TYPE = "javax.faces.Command";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";

    public UICommand() {
        this.setRendererType("javax.faces.Button");
    }

    public MethodBinding getAction() {
        MethodExpression actionExpression = this.getActionExpression();
        if (actionExpression instanceof _MethodBindingToMethodExpression) {
            return ((_MethodBindingToMethodExpression)actionExpression).getMethodBinding();
        }
        if (actionExpression != null) {
            return new _MethodExpressionToMethodBinding(actionExpression);
        }
        return null;
    }

    public void setAction(MethodBinding action) {
        if (action != null) {
            this.setActionExpression(new _MethodBindingToMethodExpression(action));
        } else {
            this.setActionExpression(null);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener defaultActionListener;
            FacesContext context = this.getFacesContext();
            MethodBinding mb = this.getActionListener();
            if (mb != null) {
                mb.invoke(context, new Object[]{event});
            }
            if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event != null && event instanceof ActionEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), Boolean.FALSE);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    public MethodExpression getActionExpression() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.actionExpression));
    }

    public void setActionExpression(MethodExpression actionExpression) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionExpression), actionExpression);
    }

    public MethodBinding getActionListener() {
        return (MethodBinding)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.actionListener));
    }

    public void setActionListener(MethodBinding actionListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionListener), actionListener);
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public String getFamily() {
        return "javax.faces.Command";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        immediate,
        value,
        actionExpression,
        actionListener;

    }
}

