/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import org.jacorb.orb.ORB;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.orb.listener.SSLSessionListener;
import org.slf4j.Logger;

public class SSLListenerUtil {
    public static void addListener(ORB oRB, Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSessionListener sSLSessionListener = oRB.getTransportManager().getSocketFactoryManager().getSSLListener();
            Logger logger = oRB.getConfiguration().getLogger("jacorb.ssl.sessionlistener");
            ((SSLSocket)socket).addHandshakeCompletedListener(new SSLHandshakeListener(logger, sSLSessionListener));
        }
    }

    public static void processException(ORB oRB, IIOPConnection iIOPConnection, Socket socket, IOException iOException) {
        String string;
        SSLSessionListener sSLSessionListener = oRB.getTransportManager().getSocketFactoryManager().getSSLListener();
        Logger logger = oRB.getConfiguration().getLogger("jacorb.ssl.sessionlistener");
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to resolve local IP address - using default");
            }
            string = "127.0.0.1";
        }
        if (iOException instanceof SSLHandshakeException) {
            sSLSessionListener.handshakeException(new SSLSessionEvent(iIOPConnection, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), string, iOException));
        } else if (iOException instanceof SSLKeyException) {
            sSLSessionListener.keyException(new SSLSessionEvent(iIOPConnection, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), string, iOException));
        } else if (iOException instanceof SSLPeerUnverifiedException) {
            sSLSessionListener.peerUnverifiedException(new SSLSessionEvent(iIOPConnection, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), string, iOException));
        } else if (iOException instanceof SSLProtocolException) {
            sSLSessionListener.protocolException(new SSLSessionEvent(iIOPConnection, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), string, iOException));
        } else if (iOException instanceof SSLException) {
            sSLSessionListener.sslException(new SSLSessionEvent(iIOPConnection, socket.getInetAddress().getHostAddress(), socket.getPort(), null, socket.getLocalPort(), string, iOException));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unknown exception type " + iOException.getClass().getName() + " with exception " + iOException);
        }
    }
}

