/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.nav.BaseTreeNode;
import org.jboss.on.embedded.ui.nav.DummyTreeNode;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.PlatformResourceTreeNode;
import org.jboss.on.embedded.ui.nav.ResourceTypeTreeNode;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.core.Events;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

@Name(value="navigationContent")
public class NavigationContent {
    private final Log log = LogFactory.getLog(this.getClass());
    @In(value="rootNode", create=true)
    @Out(value="rootNode", scope=ScopeType.APPLICATION)
    private JONTreeNode rootNode;

    @Factory(value="rootNode")
    public JONTreeNode createJONTreeNode() {
        this.log.trace((Object)"createJONTreeNode factory method being called.");
        DummyTreeNode dummy = new DummyTreeNode();
        PlatformResourceTreeNode platform = new PlatformResourceTreeNode(ResourceManagerFactory.resourceManager().getPlatform());
        dummy.addChild(platform);
        Events.instance().raiseEvent("navTreeInitialized", new Object[0]);
        return dummy;
    }

    @Observer(value={"resourceCreated"})
    public void updateNavWithNewResource(ResourceType typeOfNewResource, Resource parentResource) {
        this.log.trace((Object)("Resource of type [" + typeOfNewResource + "] added beneath Resource [" + parentResource + "] - updating nav tree..."));
        JONTreeNode parentResourceNode = this.findNode(this.getResourcePath(parentResource));
        ResourceTypeTreeNode resourceTypeNode = this.findNodeByResourceTypeAndParent(typeOfNewResource, parentResourceNode);
        if (resourceTypeNode == null) {
            parentResourceNode.reInitializeChildrenMap();
        } else {
            resourceTypeNode.reInitializeChildrenMap();
        }
    }

    @Observer(value={"resourceDeleted"})
    public void updateNavWithDeletedResource(Resource deletedResource) {
        this.log.trace((Object)("Resource [" + deletedResource + "] deleted - updating nav tree..."));
        JONTreeNode node = this.findNode(this.getResourcePath(deletedResource));
        if (node == null) {
            this.log.warn((Object)("Unable to find node for deleted resource [" + deletedResource + "]."));
            return;
        }
        JONTreeNode parentNode = node.getParent();
        parentNode.reInitializeChildrenMap();
    }

    @Observer(value={"resourceUpdated"})
    public void updateNavWithUpdatedResource(Resource updatedResource) {
    }

    private JONTreeNode findNode(String path) {
        return this.rootNode.findNode(path);
    }

    private ResourceTypeTreeNode findNodeByResourceTypeAndParent(ResourceType resourceType, JONTreeNode parentResourceNode) {
        return ((BaseTreeNode)parentResourceNode).findNodeByType(resourceType);
    }

    private String getResourcePath(Resource resource) {
        return this.getResourcePath(resource.getId());
    }

    private String getResourcePath(Integer resourceId) {
        return String.valueOf(resourceId);
    }
}

