/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectUtils {
    private SelectUtils() {
    }

    static boolean matchValue(FacesContext ctx, UIComponent component, Object value, Iterator<SelectItem> items, Converter converter) {
        while (items.hasNext()) {
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                Object[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (subitems == null || subitems.length <= 0 || !SelectUtils.matchValue(ctx, component, value, new ArrayIterator(subitems), converter)) continue;
                return true;
            }
            Object compareValue = null;
            try {
                compareValue = SelectUtils.doConversion(ctx, component, item, value, converter);
            }
            catch (IllegalStateException ise) {
                continue;
            }
            if (null == compareValue && null == value) {
                return true;
            }
            if (!value.equals(compareValue)) continue;
            return true;
        }
        return false;
    }

    static boolean valueIsNoSelectionOption(FacesContext ctx, UIComponent component, Object value, Iterator<SelectItem> items, Converter converter) {
        boolean result = false;
        while (items.hasNext()) {
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                Object[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (subitems == null || subitems.length <= 0 || !SelectUtils.valueIsNoSelectionOption(ctx, component, value, new ArrayIterator(subitems), converter)) continue;
                result = true;
                break;
            }
            Object compareValue = null;
            try {
                compareValue = SelectUtils.doConversion(ctx, component, item, value, converter);
            }
            catch (IllegalStateException ise) {
                continue;
            }
            if (null == compareValue && null == value && item.isNoSelectionOption()) {
                result = true;
                break;
            }
            if (!value.equals(compareValue) || !item.isNoSelectionOption()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static Object doConversion(FacesContext ctx, UIComponent component, SelectItem item, Object value, Converter converter) throws IllegalStateException {
        Object compareValue;
        Object itemValue = item.getValue();
        if (itemValue == null && value == null) {
            return null;
        }
        if (value == null ^ itemValue == null) {
            throw new IllegalStateException("Either value was null, or itemValue was null, but not both.");
        }
        if (converter == null) {
            compareValue = SelectUtils.coerceToModelType(ctx, itemValue, value.getClass());
        } else {
            compareValue = itemValue;
            if (compareValue instanceof String && !(value instanceof String)) {
                compareValue = converter.getAsObject(ctx, component, (String)compareValue);
            }
        }
        return compareValue;
    }

    private static Object coerceToModelType(FacesContext ctx, Object value, Class toType) {
        Object newValue;
        try {
            ExpressionFactory ef = ctx.getApplication().getExpressionFactory();
            newValue = ef.coerceToType(value, toType);
        }
        catch (ELException ele) {
            newValue = value;
        }
        catch (IllegalArgumentException iae) {
            newValue = value;
        }
        return newValue;
    }

    static class ArrayIterator
    implements Iterator {
        private Object[] items;
        private int index = 0;

        public ArrayIterator(Object[] items) {
            this.items = items;
        }

        public boolean hasNext() {
            return this.index < this.items.length;
        }

        public Object next() {
            try {
                return this.items[this.index++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

