/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessObserverMethodImpl<T, X>
extends AbstractDefinitionContainerEvent
implements ProcessObserverMethod<T, X> {
    private final AnnotatedMethod<X> beanMethod;
    private final ObserverMethod<T> observerMethod;

    public static <T, X> void fire(BeanManagerImpl beanManager, ObserverMethodImpl<T, X> observer) {
        if (beanManager.isBeanEnabled(observer.getDeclaringBean())) {
            new ProcessObserverMethodImpl<T, X>(beanManager, (AnnotatedMethod)Reflections.cast(observer.getMethod()), (ObserverMethodImpl)observer){}.fire();
        }
    }

    public ProcessObserverMethodImpl(BeanManagerImpl beanManager, AnnotatedMethod<X> beanMethod, ObserverMethodImpl<T, X> observerMethod) {
        super(beanManager, (Type)((Object)ProcessObserverMethod.class), new Type[]{observerMethod.getObservedType(), observerMethod.getMethod().getDeclaringType().getBaseType()});
        this.beanMethod = beanMethod;
        this.observerMethod = observerMethod;
    }

    public void addDefinitionError(Throwable t) {
        this.getErrors().add(t);
    }

    public AnnotatedMethod<X> getAnnotatedMethod() {
        return this.beanMethod;
    }

    public ObserverMethod<T> getObserverMethod() {
        return this.observerMethod;
    }

    public List<Throwable> getDefinitionErrors() {
        return Collections.unmodifiableList(this.getErrors());
    }
}

