/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeUtils {
    public static <T, U, V> void doubleMerge(Map<T, Map<U, Set<V>>> dest, Map<T, Map<U, Set<V>>> src) {
        if (dest == null) {
            throw new IllegalArgumentException("Null dest");
        }
        if (src == null) {
            return;
        }
        for (Map.Entry<T, Map<U, Set<V>>> entry : src.entrySet()) {
            Map<U, Set<V>> dVal = dest.get(entry.getKey());
            if (dVal != null) {
                Map<U, Set<V>> sVal = entry.getValue();
                MergeUtils.singleMerge(dVal, sVal);
                continue;
            }
            dest.put(entry.getKey(), entry.getValue());
        }
    }

    public static <U, V> void singleMerge(Map<U, Set<V>> dest, Map<U, Set<V>> src) {
        if (dest == null) {
            throw new IllegalArgumentException("Null dest");
        }
        if (src == null) {
            return;
        }
        for (Map.Entry<U, Set<V>> entry : src.entrySet()) {
            Set<V> dSet = dest.get(entry.getKey());
            if (dSet != null) {
                dSet.addAll((Collection)entry.getValue());
                continue;
            }
            dest.put(entry.getKey(), entry.getValue());
        }
    }
}

