/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.captcha;

import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.captcha.Captcha;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.web.AbstractResource;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.captcha.captchaImage")
@BypassInterceptors
@Install(precedence=0)
public class CaptchaImage
extends AbstractResource {
    public static CaptchaImage instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        return (CaptchaImage)Contexts.getApplicationContext().get(CaptchaImage.class);
    }

    public String getResourcePath() {
        return "/captcha";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ServletLifecycle.beginRequest(request);
        try {
            ImageIO.write((RenderedImage)Captcha.instance().renderChallenge(), "jpeg", out);
        }
        finally {
            ServletLifecycle.endRequest(request);
        }
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        response.getOutputStream().write(out.toByteArray());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }
}

