/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetServiceDetail;
import org.apache.juddi.datatype.response.ServiceDetail;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetServiceDetailFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$GetServiceDetailFunction == null ? (class$org$apache$juddi$function$GetServiceDetailFunction = GetServiceDetailFunction.class$("org.apache.juddi.function.GetServiceDetailFunction")) : class$org$apache$juddi$function$GetServiceDetailFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$GetServiceDetailFunction;

    public GetServiceDetailFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetServiceDetail request = (GetServiceDetail)regObject;
        String generic = request.getGeneric();
        Vector keyVector = request.getServiceKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            for (int i = 0; i < keyVector.size(); ++i) {
                String serviceKey = (String)keyVector.elementAt(i);
                if (serviceKey != null && serviceKey.length() != 0 && dataStore.isValidServiceKey(serviceKey)) continue;
                throw new InvalidKeyPassedException("get_serviceDetail: serviceKey=" + serviceKey);
            }
            Vector<BusinessService> serviceVector = new Vector<BusinessService>();
            for (int i = 0; i < keyVector.size(); ++i) {
                String serviceKey = (String)keyVector.elementAt(i);
                serviceVector.add(dataStore.fetchService(serviceKey));
            }
            dataStore.commit();
            ServiceDetail detail = new ServiceDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setBusinessServiceVector(serviceVector);
            ServiceDetail serviceDetail = detail;
            return serviceDetail;
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

