/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.core.framework.server;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.ha.core.framework.server.ChannelSource;
import org.jboss.ha.core.framework.server.CoreGroupCommunicationService;
import org.jboss.ha.core.framework.server.DistributedReplicantManagerImpl;
import org.jboss.ha.core.framework.server.ManagedDistributedState;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.GroupMembershipListener;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.SerializableStateTransferResult;
import org.jboss.ha.framework.interfaces.StateTransferProvider;

public class HAPartitionImpl
extends CoreGroupCommunicationService
implements HAPartition {
    public static final Short HAPARTITION_SCOPE_ID = 111;
    private final Map<String, HAPartition.HAPartitionStateTransfer> initialStateRecipients = new ConcurrentHashMap<String, HAPartition.HAPartitionStateTransfer>();
    private DistributedReplicantManagerImpl replicantManager;
    private DistributedState distributedState;

    public HAPartitionImpl() {
        this.setScopeId(HAPARTITION_SCOPE_ID);
        this.logHistory("Partition object created");
    }

    public String getPartitionName() {
        return this.getGroupName();
    }

    public DistributedReplicantManager getDistributedReplicantManager() {
        return this.replicantManager;
    }

    public DistributedState getDistributedStateService() {
        return this.distributedState;
    }

    public void registerMembershipListener(HAPartition.HAMembershipListener listener) {
        GroupMembershipListenerAdapter adapter = new GroupMembershipListenerAdapter(listener);
        boolean isAsynch = !this.getAllowSynchronousMembershipNotifications() || listener instanceof HAPartition.AsynchHAMembershipListener || listener instanceof HAPartition.AsynchHAMembershipExtendedListener;
        this.registerGroupMembershipListener(adapter, !isAsynch);
    }

    public void unregisterMembershipListener(HAPartition.HAMembershipListener listener) {
        GroupMembershipListenerAdapter adapter = new GroupMembershipListenerAdapter(listener);
        boolean isAsynch = !this.getAllowSynchronousMembershipNotifications() || listener instanceof HAPartition.AsynchHAMembershipListener || listener instanceof HAPartition.AsynchHAMembershipExtendedListener;
        this.unregisterGroupMembershipListener(adapter, !isAsynch);
    }

    public void subscribeToStateTransferEvents(String serviceName, HAPartition.HAPartitionStateTransfer subscriber) {
        StateTransferProviderAdapter provider = new StateTransferProviderAdapter(subscriber);
        this.registerStateTransferProvider(serviceName, provider);
        this.initialStateRecipients.put(serviceName, subscriber);
    }

    public void unsubscribeFromStateTransferEvents(String serviceName, HAPartition.HAPartitionStateTransfer subscriber) {
        this.initialStateRecipients.remove(serviceName);
    }

    public void setDistributedStateImpl(DistributedState distributedState) {
        this.distributedState = distributedState;
    }

    public void setPartitionName(String newName) {
        this.setGroupName(newName);
    }

    public DistributedReplicantManagerImpl getDistributedReplicantManagerImpl() {
        return this.replicantManager;
    }

    protected void createService() throws Exception {
        this.log.info((Object)("Initializing partition " + this.getPartitionName()));
        this.logHistory("Initializing partition " + this.getPartitionName());
        if (this.distributedState instanceof ManagedDistributedState) {
            ((ManagedDistributedState)this.distributedState).createService();
        }
        if (this.getChannelSource() == null && this.distributedState instanceof ChannelSource) {
            this.log.debug((Object)("Using " + this.distributedState + " as a " + ChannelSource.class.getSimpleName()));
            this.setChannelSource((ChannelSource)this.distributedState);
        }
        super.createService();
        if (this.replicantManager == null) {
            this.replicantManager = new DistributedReplicantManagerImpl(this);
        }
        this.replicantManager.createService();
        this.log.debug((Object)("done initializing partition " + this.getPartitionName()));
    }

    protected void startService() throws Exception {
        this.logHistory("Starting partition " + this.getPartitionName());
        if (this.distributedState instanceof ManagedDistributedState) {
            ((ManagedDistributedState)this.distributedState).startService();
        }
        super.startService();
        this.fetchInitialState();
        this.replicantManager.startService();
    }

    protected void stopService() throws Exception {
        this.logHistory("Stopping partition");
        this.log.info((Object)("Stopping partition " + this.getPartitionName()));
        this.replicantManager.stopService();
        super.stopService();
        if (this.distributedState instanceof ManagedDistributedState) {
            ((ManagedDistributedState)this.distributedState).stopService();
        }
        this.log.info((Object)("Partition " + this.getPartitionName() + " stopped."));
    }

    protected void destroyService() {
        this.log.debug((Object)("Destroying HAPartition: " + this.getPartitionName()));
        try {
            this.replicantManager.destroyService();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((Object)("Destroying " + DistributedReplicantManager.class.getSimpleName() + " failed"), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)("Destroying " + DistributedReplicantManager.class.getSimpleName() + " failed"), (Throwable)e);
        }
        super.destroyService();
        try {
            if (this.distributedState instanceof ManagedDistributedState) {
                ((ManagedDistributedState)this.distributedState).destroyService();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((Object)("Destroying " + DistributedReplicantManager.class.getSimpleName() + " failed"), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)("Destroying " + DistributedReplicantManager.class.getSimpleName() + " failed"), (Throwable)e);
        }
        this.log.info((Object)("Partition " + this.getPartitionName() + " destroyed."));
    }

    private void fetchInitialState() throws Exception {
        this.log.info((Object)("Fetching initial service state (will wait for " + this.getStateTransferTimeout() + " milliseconds for each service):"));
        for (Map.Entry<String, HAPartition.HAPartitionStateTransfer> entry : this.initialStateRecipients.entrySet()) {
            this.log.debug((Object)("Fetching state for " + entry.getKey()));
            Future<SerializableStateTransferResult> future = this.getServiceState(entry.getKey());
            SerializableStateTransferResult result = future.get(this.getStateTransferTimeout(), TimeUnit.MILLISECONDS);
            if (result.stateReceived()) {
                if (result.getStateTransferException() != null) {
                    throw result.getStateTransferException();
                }
                entry.getValue().setCurrentState(result.getState());
                this.log.debug((Object)("Received state for " + entry.getKey()));
                continue;
            }
            if (result.getStateTransferException() != null) {
                throw result.getStateTransferException();
            }
            this.log.debug((Object)("No state available for " + entry.getKey() + " -- we must be sole member of group"));
        }
    }

    private static class StateTransferProviderAdapter
    implements StateTransferProvider {
        private final HAPartition.HAPartitionStateTransfer delegate;

        StateTransferProviderAdapter(HAPartition.HAPartitionStateTransfer delegate) {
            this.delegate = delegate;
        }

        public Serializable getCurrentState() {
            return this.delegate.getCurrentState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupMembershipListenerAdapter
    implements GroupMembershipListener {
        private final HAPartition.HAMembershipListener target;

        GroupMembershipListenerAdapter(HAPartition.HAMembershipListener target) {
            this.target = target;
        }

        public void membershipChanged(List<ClusterNode> deadMembers, List<ClusterNode> newMembers, List<ClusterNode> allMembers) {
            this.target.membershipChanged(GroupMembershipListenerAdapter.castMembers(deadMembers), GroupMembershipListenerAdapter.castMembers(newMembers), GroupMembershipListenerAdapter.castMembers(allMembers));
        }

        public void membershipChangedDuringMerge(List<ClusterNode> deadMembers, List<ClusterNode> newMembers, List<ClusterNode> allMembers, List<List<ClusterNode>> originatingGroups) {
            if (this.target instanceof HAPartition.HAMembershipExtendedListener) {
                ((HAPartition.HAMembershipExtendedListener)this.target).membershipChangedDuringMerge(GroupMembershipListenerAdapter.castMembers(deadMembers), GroupMembershipListenerAdapter.castMembers(newMembers), GroupMembershipListenerAdapter.castMembers(allMembers), GroupMembershipListenerAdapter.castOriginatingGroups(originatingGroups));
            } else {
                this.membershipChanged(deadMembers, newMembers, allMembers);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof GroupMembershipListenerAdapter && ((GroupMembershipListenerAdapter)obj).target.equals(this.target);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        private static Vector<ClusterNode> castMembers(List<ClusterNode> members) {
            return members instanceof Vector ? (Vector<Object>)members : new Vector<ClusterNode>(members);
        }

        private static Vector<List<ClusterNode>> castOriginatingGroups(List<List<ClusterNode>> groups) {
            return groups instanceof Vector ? (Vector<Object>)groups : new Vector<List<ClusterNode>>(groups);
        }
    }
}

