/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;

public class SetPropertyActionListenerHandler
extends TagHandler
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute _target;
    private final TagAttribute _value = this.getRequiredAttribute("value");

    public SetPropertyActionListenerHandler(TagConfig config) {
        super(config);
        this._target = this.getRequiredAttribute("target");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, (AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not composite component or of type ActionSource, type is: " + parent);
        }
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        ActionSource src = (ActionSource)parent;
        ValueExpression valueExpr = this._value.getValueExpression(faceletContext, Object.class);
        ValueExpression targetExpr = this._target.getValueExpression(faceletContext, Object.class);
        src.addActionListener((ActionListener)new SetPropertyListener(valueExpr, targetExpr));
    }

    public String getFor() {
        TagAttribute forAttribute = this.getAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    private static class SetPropertyListener
    implements ActionListener,
    Serializable {
        private ValueExpression _target;
        private ValueExpression _value;

        public SetPropertyListener() {
        }

        public SetPropertyListener(ValueExpression value, ValueExpression target) {
            this._value = value;
            this._target = target;
        }

        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext faces = FacesContext.getCurrentInstance();
            ELContext el = faces.getELContext();
            Object valueObj = this._value.getValue(el);
            this._target.setValue(el, valueObj);
        }
    }
}

