/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.net.URL;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpAuthSupplier;

public abstract class HttpBasicAuthSupplier
extends HttpAuthSupplier {
    protected HttpBasicAuthSupplier() {
    }

    protected HttpBasicAuthSupplier(String name) {
        super(name);
    }

    public String getAuthorizationForRealm(HTTPConduit conduit, URL currentURL, Message message, String realm, String fullHeader) {
        UserPass up = this.getUserPassForRealm(conduit.getConduitName(), currentURL, message, realm);
        if (up != null) {
            String key = up.getUserid() + ":" + up.getPassword();
            return "Basic " + Base64Utility.encode((byte[])key.getBytes());
        }
        return null;
    }

    public String getPreemptiveAuthorization(HTTPConduit conduit, URL currentURL, Message message) {
        UserPass up = this.getPreemptiveUserPass(conduit.getConduitName(), currentURL, message);
        if (up != null) {
            String key = up.getUserid() + ":" + up.getPassword();
            return "Basic " + Base64Utility.encode((byte[])key.getBytes());
        }
        return null;
    }

    protected UserPass createUserPass(String userid, String password) {
        return new UserPass(userid, password);
    }

    public abstract UserPass getPreemptiveUserPass(String var1, URL var2, Message var3);

    public abstract UserPass getUserPassForRealm(String var1, URL var2, Message var3, String var4);

    public static final class UserPass {
        private final String userid;
        private final String password;

        UserPass(String user, String pass) {
            if (user.contains(":")) {
                throw new IllegalArgumentException("The argument \"user\" cannot contain ':'.");
            }
            this.userid = user;
            this.password = pass;
        }

        public String getUserid() {
            return this.userid;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

