/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.metadata.spi.MetaData;
import org.jboss.profileservice.management.mbean.spi.MBeanManagedObjectFactory;
import org.jboss.profileservice.management.mbean.spi.ManagedMBeanDeploymentFactory;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.management.util.ManagedDeploymentProcessor;
import org.jboss.profileservice.plugins.management.view.AbstractProfileView;
import org.jboss.profileservice.plugins.management.view.AbstractProfileViewWrapper;
import org.jboss.profileservice.plugins.spi.ProfileView;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ProfileModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanProfileView
extends AbstractProfileViewWrapper {
    private static final Logger log = Logger.getLogger(MBeanProfileView.class);
    private AbstractProfileView view = new AbstractProfileView();
    private HashMap<String, ManagedMBeanDeploymentFactory> mdfs = new HashMap();
    private MBeanServer mbeanServer;
    private MBeanManagedObjectFactory mbeanMOFactory = new MBeanManagedObjectFactory();
    private AbstractManagementProxyFactory mbeanProxyFactory;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public AbstractManagementProxyFactory getMbeanProxyFactory() {
        return this.mbeanProxyFactory;
    }

    public void setMbeanProxyFactory(AbstractManagementProxyFactory mbeanProxyFactory) {
        this.mbeanProxyFactory = mbeanProxyFactory;
    }

    public AbstractManagementProxyFactory getProxyFactory() {
        return this.getMbeanProxyFactory();
    }

    public void addManagedMBeanDeployments(ManagedMBeanDeploymentFactory factory) {
        log.trace((Object)("addManagedDeployment, " + factory));
        String name = factory.getFactoryName();
        this.mdfs.put(name, factory);
    }

    public void removeManagedMBeanDeployments(ManagedMBeanDeploymentFactory factory) {
        log.trace((Object)("removeManagedDeployment, " + factory));
        String name = factory.getFactoryName();
        this.mdfs.remove(name);
    }

    protected ProfileView getDelegate() {
        return this.view;
    }

    public boolean load() {
        if (this.view.load()) {
            for (ManagedMBeanDeploymentFactory mdf : this.mdfs.values()) {
                log.trace((Object)("Processing deployments for factory: " + mdf.getFactoryName()));
                Collection<ManagedMBeanDeploymentFactory.MBeanDeployment> deployments = mdf.getDeployments(this.mbeanServer);
                for (ManagedMBeanDeploymentFactory.MBeanDeployment md : deployments) {
                    log.trace((Object)("Saw MBeanDeployment: " + md));
                    HashMap<String, ManagedObject> unitMOs = new HashMap<String, ManagedObject>();
                    Collection<ManagedMBeanDeploymentFactory.MBeanComponent> components = md.getComponents();
                    if (components != null) {
                        for (ManagedMBeanDeploymentFactory.MBeanComponent comp : components) {
                            log.trace((Object)("Saw MBeanComponent: " + comp));
                            try {
                                ManagedObject mo = this.createManagedObject(comp.getName(), mdf.getDefaultViewUse(), mdf.getPropertyMetaMappings());
                                String name = comp.getName().getCanonicalName();
                                ManagementObject moAnn = this.createMOAnnotation(name, comp.getType(), comp.getSubtype());
                                mo.getAnnotations().put(ManagementObject.class.getName(), moAnn);
                                ManagementComponent mcAnn = moAnn.componentType();
                                mo.getAnnotations().put(ManagementComponent.class.getName(), mcAnn);
                                unitMOs.put(name, mo);
                            }
                            catch (Exception e) {
                                log.warn((Object)("Failed to create ManagedObject for: " + comp), (Throwable)e);
                            }
                        }
                    }
                    try {
                        ManagedDeploymentProcessor processor = new ManagedDeploymentProcessor(this.mbeanProxyFactory);
                        ManagedDeploymentImpl mdi = new ManagedDeploymentImpl(md.getName(), md.getName(), null, unitMOs);
                        mdi.setTypes(Collections.singleton("external-mbean"));
                        processor.processRootManagedDeployment((ManagedDeployment)mdi, DeploymentState.STARTED, (ProfileViewProcessingContext)this.view);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to process ManagedDeployment for: " + md.getName()), (Throwable)e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private ManagedObject createManagedObject(ObjectName mbean, String defaultViewUse, Map<String, String> propertyMetaMappings) throws Exception {
        ViewUse[] viewUseArray;
        MBeanInfo info = this.mbeanServer.getMBeanInfo(mbean);
        ClassLoader mbeanLoader = this.mbeanServer.getClassLoaderFor(mbean);
        MetaData metaData = null;
        if (defaultViewUse == null) {
            viewUseArray = null;
        } else {
            ViewUse[] viewUseArray2 = new ViewUse[1];
            viewUseArray = viewUseArray2;
            viewUseArray2[0] = ViewUse.valueOf((String)defaultViewUse);
        }
        ViewUse[] viewUse = viewUseArray;
        ManagedObject mo = this.mbeanMOFactory.getManagedObject(mbean, info, mbeanLoader, metaData, viewUse, propertyMetaMappings);
        return mo;
    }

    public void removeComponent(ManagedComponent update, ManagedComponent original) throws Exception {
    }

    public void updateComponent(ManagedComponent update, ManagedComponent original) throws Exception {
    }

    public void notify(ModificationEvent event) {
        if (event.getModificationType() != ProfileModificationType.GET) {
            this.view.markAsModified();
        }
    }

    private ManagementObject createMOAnnotation(String name, String type, String subtype) {
        return new ManagementObjectAnnotationImpl(name, type, subtype);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ManagementObjectAnnotationImpl
    implements ManagementObject,
    Serializable {
        private static final long serialVersionUID = 5355799336353299850L;
        private final String name;
        private final String type;
        private final String subtype;

        private ManagementObjectAnnotationImpl(String name, String type, String subtype) {
            this.name = name;
            this.type = type;
            this.subtype = subtype;
        }

        public String attachmentName() {
            return "";
        }

        public ManagementProperty[] classProperties() {
            return new ManagementProperty[0];
        }

        public ManagementComponent componentType() {
            return new ManagementComponentAnnotationImpl();
        }

        public String description() {
            return "";
        }

        public boolean isRuntime() {
            return true;
        }

        public String name() {
            return this.name;
        }

        public ManagementOperation[] operations() {
            return new ManagementOperation[0];
        }

        public ManagementProperties properties() {
            return ManagementProperties.ALL;
        }

        public Class<?> targetInterface() {
            return Object.class;
        }

        public String type() {
            return "";
        }

        public Class<? extends Annotation> annotationType() {
            return ManagementObject.class;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ManagementComponentAnnotationImpl
        implements ManagementComponent,
        Serializable {
            private static final long serialVersionUID = 5355799336353299850L;

            private ManagementComponentAnnotationImpl() {
            }

            public String subtype() {
                return ManagementObjectAnnotationImpl.this.subtype;
            }

            public String type() {
                return ManagementObjectAnnotationImpl.this.type;
            }

            public Class<? extends Annotation> annotationType() {
                return ManagementComponent.class;
            }
        }
    }
}

