/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;

@Marshallable(externalizer=Externalizer.class, id=51)
public class ExperimentalDefaultConsistentHash
extends AbstractConsistentHash {
    private static final int DEFAULT_WEIGHT = 1;
    private static final int DEFAULT_WEIGHTFACTOR = 1;
    private List<Address> nodes;
    private List<Entry> pool;
    private int poolSize;

    @Override
    public List<Address> getCaches() {
        return this.nodes;
    }

    @Override
    public void setCaches(List<Address> caches) {
        this.nodes = caches;
        int numNodes = this.nodes.size();
        int poolSize = 0;
        for (int i = 0; i < numNodes; ++i) {
            ++poolSize;
        }
        this.poolSize = poolSize;
        this.pool = new ArrayList<Entry>(poolSize);
        int numEntries = 0;
        for (int i = 0; i < numNodes; ++i) {
            numEntries = this.add(this.nodes.get(i), 1, numEntries);
        }
        Collections.sort(this.pool);
        this.nodes = this.getSortedCachesList();
    }

    private List<Address> getSortedCachesList() {
        ArrayList<Address> caches = new ArrayList<Address>();
        for (Entry e : this.pool) {
            if (caches.contains(e.address)) continue;
            caches.add(e.address);
        }
        caches.trimToSize();
        return caches;
    }

    private int add(Address node, int count, int position) {
        String nodeName = node.toString();
        for (int i = 0; i < count; ++i) {
            int hash = this.hash((Integer.toString(i) + nodeName).getBytes());
            this.pool.add(position++, new Entry(node, nodeName, i, hash));
        }
        return position;
    }

    public int getDistance(Address a1, Address a2) {
        if (a1 == null || a2 == null) {
            throw new NullPointerException("Cannot find the distance between null servers.");
        }
        int p1 = this.nodes.indexOf(a1);
        if (p1 < 0) {
            throw new IllegalArgumentException("Address " + a1 + " not in the addresses list of this consistent hash impl!");
        }
        int p2 = this.nodes.indexOf(a2);
        if (p2 < 0) {
            throw new IllegalArgumentException("Address " + a2 + " not in the addresses list of this consistent hash impl!");
        }
        if (p1 <= p2) {
            return p2 - p1;
        }
        return this.pool.size() - (p1 - p2);
    }

    public boolean isAdjacent(Address a1, Address a2) {
        int distance = this.getDistance(a1, a2);
        return distance == 1 || distance == this.pool.size() - 1;
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        if (key == null) {
            throw new NullPointerException("Attempt to get with null key");
        }
        int clusterSize = this.pool.size();
        int numCopiesToFind = Math.min(replCount, clusterSize);
        int hashValue = this.hash(key);
        return this.locate(hashValue, numCopiesToFind, replCount);
    }

    private List<Address> locate(int hashValue, int numCopiesToFind, int replCount) {
        int inode = this.findNearestNodeInPool(hashValue);
        ArrayList<Address> nodes = new ArrayList<Address>(numCopiesToFind);
        for (int checked = 0; nodes.size() < replCount && checked < this.poolSize; ++checked) {
            Entry poolEntry = this.pool.get(inode);
            if (poolEntry != null && nodes.indexOf(poolEntry.address) < 0) {
                nodes.add(poolEntry.address);
            }
            ++inode;
            inode %= this.poolSize;
        }
        return nodes;
    }

    private int binarySearch(int hash) {
        int lowerBound = 0;
        int upperBound = this.pool.size() - 1;
        while (lowerBound <= upperBound) {
            int mid = lowerBound + upperBound >>> 1;
            int currentHash = this.pool.get((int)mid).hash;
            if (currentHash < hash) {
                lowerBound = mid + 1;
                continue;
            }
            if (currentHash > hash) {
                upperBound = mid - 1;
                continue;
            }
            return mid;
        }
        return -(lowerBound + 1);
    }

    private int findNearestNodeInPool(int hash) {
        int nodeIndex = this.binarySearch(hash);
        if (nodeIndex < 0 && (nodeIndex = -(nodeIndex + 1)) >= this.pool.size()) {
            nodeIndex = 0;
        }
        return nodeIndex;
    }

    private int hash(Object object) {
        int hash = object.hashCode();
        hash = hash + 2127912214 + (hash << 12);
        hash = hash ^ 0xC761C23C ^ hash >> 19;
        hash = hash + 374761393 + (hash << 5);
        hash = hash + -744332180 ^ hash << 9;
        hash = hash + -42973499 + (hash << 3);
        hash = hash ^ 0xB55A4F09 ^ hash >> 16;
        return hash;
    }

    @Override
    public int getHashId(Address a) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getHashSpace() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String toString() {
        return " pool: " + this.pool;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ExperimentalDefaultConsistentHash)) {
            return false;
        }
        ExperimentalDefaultConsistentHash otherHash = (ExperimentalDefaultConsistentHash)other;
        return Util.safeEquals(this.pool, otherHash.pool);
    }

    public int hashCode() {
        int hashCode = 1;
        for (Entry e : this.pool) {
            hashCode = 31 * hashCode + e.hash;
        }
        return hashCode;
    }

    @Override
    public List<Address> getStateProvidersOnLeave(Address leaver, int replCount) {
        HashSet<Address> holders = new HashSet<Address>();
        for (Address address : this.nodes) {
            if (!this.isAdjacent(leaver, address)) continue;
            holders.add(address);
        }
        return new ArrayList<Address>(holders);
    }

    @Override
    public List<Address> getStateProvidersOnJoin(Address joiner, int replCount) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public List<Address> getBackupsForNode(Address node, int replCount) {
        throw new RuntimeException("Not implemented!");
    }

    public static class Entry
    implements Comparable<Entry> {
        public final int differentiator;
        public final int hash;
        public final Address address;
        public final String string;

        public Entry(Address address, String string, int differentiator, int hash) {
            this.differentiator = differentiator;
            this.hash = hash;
            this.address = address;
            this.string = string;
        }

        @Override
        public int compareTo(Entry other) {
            if (this.hash < other.hash) {
                return -1;
            }
            if (this.hash > other.hash) {
                return 1;
            }
            if (this.differentiator < other.differentiator) {
                return -1;
            }
            if (this.differentiator > other.differentiator) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry otherEntry = (Entry)other;
                return this.hash == otherEntry.hash && this.differentiator == otherEntry.differentiator && this.address.equals(otherEntry.address);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.string + ":" + Integer.toHexString(this.hash);
        }
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExperimentalDefaultConsistentHash gch = (ExperimentalDefaultConsistentHash)object;
            output.writeObject(gch.nodes);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            List addresses = (List)input.readObject();
            DefaultConsistentHash gch = new DefaultConsistentHash();
            gch.setCaches(addresses);
            return gch;
        }
    }
}

