/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.logging.Logger;
import org.jnp.interfaces.MarshalledValuePair;

public class JndiSessionProxyObjectFactory
implements ObjectFactory {
    private static final Logger logger = Logger.getLogger(JndiSessionProxyObjectFactory.class);
    public static final String REF_ADDR_NAME_JNDI_BINDING_DELEGATE_PROXY_FACTORY = "FACTORY";
    public static final String REF_ADDR_NAME_BUSINESS_INTERFACE_TYPE = "BUSINESS_INTERFACE_TYPE";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = null;
        String proxyFactoryJndiBinding = null;
        ProxyFactory proxyFactory = null;
        try {
            ref = (Reference)Reference.class.cast(obj);
            logger.trace((Object)("Obtained " + Reference.class.getName() + " from " + obj));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Object at JNDI at " + nameCtx + name.toString() + " was not of expected type " + Reference.class.getName(), cce);
        }
        try {
            RefAddr refAddr = ref.get(REF_ADDR_NAME_JNDI_BINDING_DELEGATE_PROXY_FACTORY);
            Object content = refAddr.getContent();
            proxyFactoryJndiBinding = (String)String.class.cast(content);
            logger.trace((Object)(ProxyFactory.class.getName() + " is located in JNDI at " + proxyFactoryJndiBinding));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Content for Reference name FACTORY bound in JNDI at " + nameCtx + name.toString() + " was not of expected type " + String.class.getName(), cce);
        }
        Object proxyFactoryObj = nameCtx.lookup(proxyFactoryJndiBinding);
        try {
            proxyFactory = (ProxyFactory)ProxyFactory.class.cast(proxyFactoryObj);
            logger.trace((Object)("Found " + ProxyFactory.class.getName() + " instance at " + proxyFactoryJndiBinding));
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Expected " + ProxyFactory.class.getName() + " instance in JNDI at " + proxyFactoryJndiBinding + ", instead got " + proxyFactoryObj);
        }
        Object proxy = proxyFactory.createProxyBusiness();
        MarshalledValuePair marshalledProxy = new MarshalledValuePair(proxy);
        return marshalledProxy.get();
    }
}

