/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.mbeanserver;

import javax.management.MBeanServer;
import org.jboss.jmx.mbeanserver.DelegateMBeanServer;
import org.jboss.jmx.mbeanserver.DelegateState;

public class MBeanServerChain
extends DelegateMBeanServer {
    public MBeanServerChain(DelegateState state) {
        super(state);
        if (state.getOuter() == null) {
            state.setOuter(this);
        }
    }

    public void addFirst(DelegateMBeanServer server) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(this.getClass().getName()));
        }
        if (server == null) {
            throw new IllegalArgumentException("Null server");
        }
        server.setNext(this.getNext());
        this.setNext(server);
    }

    public void addLast(DelegateMBeanServer server) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(this.getClass().getName()));
        }
        if (server == null) {
            throw new IllegalArgumentException("Null server");
        }
        DelegateMBeanServer last = this;
        MBeanServer next = last.getNext();
        while (next instanceof DelegateMBeanServer) {
            last = (DelegateMBeanServer)next;
            next = last.getNext();
        }
        server.setNext(next);
        last.setNext(server);
    }

    public void setTarget(MBeanServer server) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(this.getClass().getName()));
        }
        if (server == null) {
            throw new IllegalArgumentException("Null server");
        }
        if (this.getNext() != null) {
            throw new IllegalStateException("Target is already set");
        }
        this.setNext(server);
    }
}

