/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.deployers.resolver;

import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.jndi.deployers.resolver.DependencyBuilder;
import org.jboss.ejb3.jndi.deployers.resolver.SessionBeanDependencyHandler;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

public class SessionBeanDependencyBuilder
implements DependencyBuilder {
    static final String SINGLETON = "jboss-ejb3-singleton-jndi-binder:";
    static final String NO_INTERFACE = "jboss-ejb3-nointerface-jndi-binder:";
    private SessionBeanDependencyHandler singletonHandler;
    private SessionBeanDependencyHandler sessionBeansHandler;
    private SessionBeanDependencyHandler noInterfaceHandler;
    private JavaEEComponentInformer informer;

    public SessionBeanDependencyBuilder(JavaEEComponentInformer informer) {
        if (informer == null) {
            throw new IllegalArgumentException("Null informer");
        }
        this.informer = informer;
    }

    @Override
    public void buildDependency(DeploymentUnit unit, BeanMetaDataBuilder builder) {
        JBossSessionBeanMetaData jsbmd = (JBossSessionBeanMetaData)unit.getAttachment(JBossSessionBeanMetaData.class);
        if (jsbmd != null) {
            if (jsbmd.isSession() && jsbmd.getSessionType() == SessionType.Singleton) {
                this.handleSingleton(unit, builder, jsbmd);
            } else if (jsbmd.isStateless() || jsbmd.isStateless()) {
                this.handleSessionBean(unit, builder, jsbmd);
            }
            if (this.isNoInterface(jsbmd)) {
                this.handleNoInterfaceView(unit, builder, jsbmd);
            }
        }
    }

    protected boolean isNoInterface(JBossSessionBeanMetaData jsbmd) {
        if (jsbmd.isSession() && jsbmd instanceof JBossSessionBean31MetaData) {
            JBossSessionBean31MetaData sessionBeanMetaData = (JBossSessionBean31MetaData)jsbmd;
            return sessionBeanMetaData.isNoInterfaceBean();
        }
        return false;
    }

    protected Object getName(String prefix, DeploymentUnit unit, String bean) {
        StringBuilder sb = new StringBuilder(prefix);
        String appName = this.informer.getApplicationName(unit);
        if (appName != null) {
            sb.append("application=").append(appName).append(",");
        }
        sb.append("module=").append(this.informer.getModuleName(unit)).append(",");
        sb.append("bean=").append(bean);
        return sb.toString();
    }

    protected void handleSingleton(DeploymentUnit unit, BeanMetaDataBuilder builder, JBossSessionBeanMetaData jsbmd) {
        if (this.singletonHandler != null) {
            this.singletonHandler.handle(unit, builder, jsbmd);
        } else {
            builder.addDemand(this.getName(SINGLETON, unit, jsbmd.getEjbName()), ControllerState.START, null);
        }
    }

    protected void handleSessionBean(DeploymentUnit unit, BeanMetaDataBuilder builder, JBossSessionBeanMetaData jsbmd) {
        if (this.sessionBeansHandler != null) {
            this.sessionBeansHandler.handle(unit, builder, jsbmd);
        } else {
            builder.addDemand((Object)jsbmd.getContainerName(), ControllerState.START, null);
        }
    }

    protected void handleNoInterfaceView(DeploymentUnit unit, BeanMetaDataBuilder builder, JBossSessionBeanMetaData jsbmd) {
        if (this.noInterfaceHandler != null) {
            this.noInterfaceHandler.handle(unit, builder, jsbmd);
        } else {
            builder.addDemand(this.getName(NO_INTERFACE, unit, jsbmd.getEjbName()), ControllerState.START, null);
        }
    }

    public void setSingletonHandler(SessionBeanDependencyHandler singletonHandler) {
        this.singletonHandler = singletonHandler;
    }

    public void setSessionBeansHandler(SessionBeanDependencyHandler sessionBeansHandler) {
        this.sessionBeansHandler = sessionBeansHandler;
    }

    public void setNoInterfaceHandler(SessionBeanDependencyHandler noInterfaceHandler) {
        this.noInterfaceHandler = noInterfaceHandler;
    }
}

