/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.jboss.config.ServerConfigUtil;
import org.jboss.jdbc.HypersonicDatabaseMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class HypersonicDatabase
extends ServiceMBeanSupport
implements HypersonicDatabaseMBean {
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_USER = "sa";
    private static final String JDBC_DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:hsqldb:";
    private static final String DEFAULT_REMOTE_SHUTDOWN_COMMAND = "SHUTDOWN COMPACT";
    private static final String DEFAULT_IN_PROCESS_SHUTDOWN_COMMAND = "SHUTDOWN COMPACT";
    private static final String DEFAULT_IN_MEMORY_SHUTDOWN_COMMAND = "SHUTDOWN IMMEDIATELY";
    private static final String HYPERSONIC_DATA_DIR = "hypersonic";
    private static final int DEFAULT_PORT = 1701;
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_DATABASE_NAME = "default";
    private static final String IN_MEMORY_DATABASE = ".";
    private static final String DEFAULT_DATABASE_MANAGER_CLASS = "org.hsqldb.util.DatabaseManagerSwing";
    private static final String DEFAULT_SERVER_CLASS = "org.hsqldb.Server";
    private File dbPath;
    private String name = "default";
    private int port = 1701;
    private String address = "0.0.0.0";
    private boolean silent = true;
    private boolean trace = false;
    private boolean no_system_exit = true;
    private boolean persist = true;
    private String shutdownCommand;
    private boolean inProcessMode = false;
    private String user = "sa";
    private String password = "";
    private String databaseManagerClass = "org.hsqldb.util.DatabaseManagerSwing";
    private String serverClass = "org.hsqldb.Server";
    private Thread serverThread;
    private Connection connection;
    private String dbDataDir;

    public String getDbDataDir() {
        return this.dbDataDir;
    }

    public void setDbDataDir(String dbDataDir) {
        this.dbDataDir = dbDataDir;
    }

    public void setDatabase(String name) {
        if (name == null) {
            name = DEFAULT_DATABASE_NAME;
        }
        this.name = name;
    }

    public String getDatabase() {
        return this.name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String address) {
        this.address = address;
    }

    public String getBindAddress() {
        return this.address;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setNo_system_exit(boolean no_system_exit) {
        this.no_system_exit = no_system_exit;
    }

    public boolean getNo_system_exit() {
        return this.no_system_exit;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public String getDatabasePath() {
        if (this.dbPath != null) {
            return this.dbPath.toString();
        }
        return null;
    }

    public boolean isInProcessMode() {
        return this.inProcessMode;
    }

    public String getShutdownCommand() {
        return this.shutdownCommand;
    }

    public void setInProcessMode(boolean b) {
        this.inProcessMode = b;
    }

    public void setShutdownCommand(String string) {
        this.shutdownCommand = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        if (password == null) {
            password = DEFAULT_PASSWORD;
        }
        this.password = password;
    }

    public void setUser(String user) {
        if (user == null) {
            user = DEFAULT_USER;
        }
        this.user = user;
    }

    public String getDatabaseManagerClass() {
        return this.databaseManagerClass;
    }

    public void setDatabaseManagerClass(String databaseManagerClass) {
        if (databaseManagerClass == null) {
            databaseManagerClass = DEFAULT_DATABASE_MANAGER_CLASS;
        }
        this.databaseManagerClass = databaseManagerClass;
    }

    public String getServerClass() {
        return this.serverClass;
    }

    public void setServerClass(String serverClass) {
        if (serverClass == null) {
            serverClass = DEFAULT_SERVER_CLASS;
        }
        this.serverClass = serverClass;
    }

    public void startDatabaseManager() {
        new Thread(){

            public void run() {
                try {
                    String connectHost = HypersonicDatabase.DEFAULT_ADDRESS.equals(HypersonicDatabase.this.address) ? "localhost" : HypersonicDatabase.this.address;
                    String driver = HypersonicDatabase.JDBC_DRIVER_CLASS;
                    String[] args = !HypersonicDatabase.this.inProcessMode ? new String[]{"-noexit", "-driver", driver, "-url", "jdbc:hsqldb:hsql://" + ServerConfigUtil.fixHostnameForURL((String)connectHost) + ":" + HypersonicDatabase.this.port, "-user", HypersonicDatabase.this.user, "-password", HypersonicDatabase.this.password, "-dir", HypersonicDatabase.this.getDatabasePath()} : (HypersonicDatabase.IN_MEMORY_DATABASE.equals(HypersonicDatabase.this.name) ? new String[]{"-noexit", "-driver", driver, "-url", "jdbc:hsqldb:.", "-user", HypersonicDatabase.this.user, "-password", HypersonicDatabase.this.password} : new String[]{"-noexit", "-driver", driver, "-url", HypersonicDatabase.JDBC_URL_PREFIX + HypersonicDatabase.this.getDatabasePath(), "-user", HypersonicDatabase.this.user, "-password", HypersonicDatabase.this.password, "-dir", HypersonicDatabase.this.getDatabasePath()});
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(HypersonicDatabase.this.databaseManagerClass, true, cl);
                    Method main = clazz.getMethod("main", args.getClass());
                    main.invoke(null, new Object[]{args});
                }
                catch (HeadlessException e) {
                    HypersonicDatabase.this.log.error((Object)"Failed to start database manager because this is an headless configuration (no display, mouse or keyword)");
                }
                catch (Exception e) {
                    HypersonicDatabase.this.log.error((Object)"Failed to start database manager", (Throwable)e);
                }
            }
        }.start();
    }

    protected void startService() throws Exception {
        if (!this.persist) {
            this.inProcessMode = true;
            this.name = IN_MEMORY_DATABASE;
        }
        if (!this.inProcessMode) {
            this.startRemoteDatabase();
        } else if (IN_MEMORY_DATABASE.equals(this.name)) {
            this.startInMemoryDatabase();
        } else {
            this.startStandaloneDatabase();
        }
    }

    protected void stopService() throws Exception {
        if (!this.inProcessMode) {
            this.stopRemoteDatabase();
        } else if (IN_MEMORY_DATABASE.equals(this.name)) {
            this.stopInMemoryDatabase();
        } else {
            this.stopStandaloneDatabase();
        }
    }

    private void startStandaloneDatabase() throws Exception {
        File dataDir = null;
        dataDir = this.dbDataDir == null ? new File(ServerConfigLocator.locate().getServerDataLocation().toURI()) : new File(this.dbDataDir);
        File hypersoniDir = new File(dataDir, HYPERSONIC_DATA_DIR);
        if (!hypersoniDir.exists()) {
            hypersoniDir.mkdirs();
        }
        if (!hypersoniDir.isDirectory()) {
            throw new IOException("Failed to create directory: " + hypersoniDir);
        }
        this.dbPath = new File(hypersoniDir, this.name);
        String dbURL = JDBC_URL_PREFIX + this.getDatabasePath();
        this.connection = this.getConnection(dbURL);
    }

    private void startInMemoryDatabase() throws Exception {
        String dbURL = "jdbc:hsqldb:.";
        this.connection = this.getConnection(dbURL);
    }

    private void startRemoteDatabase() throws Exception {
        File dataDir = null;
        dataDir = this.dbDataDir == null ? new File(ServerConfigLocator.locate().getServerDataLocation().toURI()) : new File(this.dbDataDir);
        File hypersoniDir = new File(dataDir, HYPERSONIC_DATA_DIR);
        if (!hypersoniDir.exists()) {
            hypersoniDir.mkdirs();
        }
        if (!hypersoniDir.isDirectory()) {
            throw new IOException("Failed to create directory: " + hypersoniDir);
        }
        this.dbPath = new File(hypersoniDir, this.name);
        this.serverThread = new Thread("hypersonic-" + this.name){

            public void run() {
                try {
                    String[] args = new String[]{"-database", HypersonicDatabase.this.dbPath.toString(), "-port", String.valueOf(HypersonicDatabase.this.port), "-address", HypersonicDatabase.this.address, "-silent", String.valueOf(HypersonicDatabase.this.silent), "-trace", String.valueOf(HypersonicDatabase.this.trace), "-no_system_exit", String.valueOf(HypersonicDatabase.this.no_system_exit)};
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(HypersonicDatabase.this.serverClass, true, cl);
                    Method main = clazz.getMethod("main", args.getClass());
                    main.invoke(null, new Object[]{args});
                }
                catch (Exception e) {
                    HypersonicDatabase.this.log.error((Object)"Failed to start database", (Throwable)e);
                }
            }
        };
        this.serverThread.start();
    }

    private void stopStandaloneDatabase() throws Exception {
        String dbURL = JDBC_URL_PREFIX + this.getDatabasePath();
        Connection connection = this.getConnection(dbURL);
        Statement statement = connection.createStatement();
        String shutdownCommand = this.shutdownCommand;
        if (shutdownCommand == null) {
            shutdownCommand = "SHUTDOWN COMPACT";
        }
        statement.executeQuery(shutdownCommand);
        this.connection = null;
        this.log.info((Object)"Database standalone closed clean");
    }

    private void stopInMemoryDatabase() throws Exception {
        String dbURL = "jdbc:hsqldb:.";
        Connection connection = this.getConnection(dbURL);
        Statement statement = connection.createStatement();
        String shutdownCommand = this.shutdownCommand;
        if (shutdownCommand == null) {
            shutdownCommand = DEFAULT_IN_MEMORY_SHUTDOWN_COMMAND;
        }
        statement.executeQuery(shutdownCommand);
        this.connection = null;
        this.log.info((Object)"Database in memory closed clean");
    }

    private void stopRemoteDatabase() throws Exception {
        String connectHost = DEFAULT_ADDRESS.equals(this.address) ? "localhost" : this.address;
        String dbURL = "jdbc:hsqldb:hsql://" + ServerConfigUtil.fixHostnameForURL((String)connectHost) + ":" + this.port;
        Connection connection = this.getConnection(dbURL);
        Statement statement = connection.createStatement();
        String shutdownCommand = this.shutdownCommand;
        if (shutdownCommand == null) {
            shutdownCommand = "SHUTDOWN COMPACT";
        }
        statement.executeQuery(shutdownCommand);
        this.serverThread = null;
        this.connection = null;
        this.log.info((Object)"Database remote closed clean");
    }

    private synchronized Connection getConnection(String dbURL) throws Exception {
        if (this.connection == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class.forName(JDBC_DRIVER_CLASS, true, cl).newInstance();
            this.connection = DriverManager.getConnection(dbURL, this.user, this.password);
        }
        return this.connection;
    }
}

