/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.plugins.management.AbstractTemplateCreator;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.spi.ProfileViewWrapper;
import org.jboss.profileservice.spi.NoSuchDeploymentException;

public class AggregatingLocalManagementView
extends AbstractTemplateCreator
implements ManagementView {
    private static final Logger log = Logger.getLogger(AggregatingLocalManagementView.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.plugins.management.messages";
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private List<ProfileViewWrapper> views = new CopyOnWriteArrayList<ProfileViewWrapper>();
    private Map<String, DeploymentTemplate> templates = new HashMap<String, DeploymentTemplate>();
    private AbstractManagementProxyFactory proxyFactory;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public AggregatingLocalManagementView() {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public AbstractManagementProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(AbstractManagementProxyFactory proxyFactory) {
        if (proxyFactory == null) {
            throw new IllegalArgumentException("null proxy factory");
        }
        this.proxyFactory = proxyFactory;
    }

    public void start() {
        if (this.proxyFactory == null) {
            throw new IllegalStateException("null proxy factory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        this.lockWrite();
        try {
            boolean wasInterrupted = Thread.interrupted();
            if (wasInterrupted) {
                log.debug((Object)"Cleared interrupted state of calling thread");
            }
            boolean changed = false;
            for (ProfileViewWrapper view : this.views) {
                if (!view.load()) continue;
                changed = true;
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
                log.debug((Object)"Restored interrupted state of calling thread");
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.unlockWrite();
        }
    }

    public void addProfileView(ProfileViewWrapper view) {
        if (view == null) {
            throw new IllegalArgumentException("null profile view");
        }
        view.setManagementProxyFactory(this.proxyFactory);
        this.views.add(view);
    }

    public void removeProfileView(ProfileViewWrapper view) {
        if (view == null) {
            throw new IllegalArgumentException("null profile view");
        }
        this.views.remove(view);
    }

    public void addTemplate(DeploymentTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("null deployment template");
        }
        if (template.getInfo() == null) {
            throw new IllegalArgumentException("null deployment template info");
        }
        if (template.getInfo().getName() == null) {
            throw new IllegalArgumentException("null deployment template info name");
        }
        this.templates.put(template.getInfo().getName(), template);
    }

    public void removeTemplate(DeploymentTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("null deployment template");
        }
        if (template.getInfo() == null) {
            throw new IllegalArgumentException("null deployment template info");
        }
        if (template.getInfo().getName() == null) {
            throw new IllegalArgumentException("null deployment template info name");
        }
        this.templates.remove(template.getInfo().getName());
    }

    public void applyTemplate(String deploymentBaseName, DeploymentTemplateInfo info) throws Exception {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null deployment base name.");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        DeploymentTemplate template = this.templates.get(info.getName());
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{info.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("applyTemplate, deploymentBaseName=" + deploymentBaseName + ", info=" + info));
        }
        super.applyTemplate(template, deploymentBaseName, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedComponent getComponent(String name, ComponentType type) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("null component name");
        }
        this.lockRead();
        try {
            ManagedComponent component = null;
            for (ProfileViewWrapper view : this.views) {
                ManagedComponent resolved = view.getComponent(name, type);
                if (resolved == null) continue;
                component = resolved;
            }
            if (component == null) {
                // empty if block
            }
            ManagedComponent managedComponent = component;
            return managedComponent;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ComponentType> getComponentTypes() {
        this.lockRead();
        try {
            HashSet<ComponentType> types = new HashSet<ComponentType>();
            for (ProfileViewWrapper view : this.views) {
                types.addAll(view.getComponentTypes());
            }
            HashSet<ComponentType> hashSet = types;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ManagedComponent> getComponentsForType(ComponentType type) {
        if (type == null) {
            throw new IllegalArgumentException("null component type");
        }
        this.lockRead();
        try {
            HashSet<ManagedComponent> components = new HashSet<ManagedComponent>();
            for (ProfileViewWrapper view : this.views) {
                components.addAll(view.getComponentsForType(type));
            }
            HashSet<ManagedComponent> hashSet = components;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedDeployment getDeployment(String name) throws NoSuchDeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("null deployment name");
        }
        this.lockRead();
        try {
            ManagedDeployment deployment = null;
            for (ProfileViewWrapper view : this.views) {
                ManagedDeployment resolved = view.getManagedDeployment(name);
                if (resolved == null) continue;
                deployment = resolved;
            }
            if (deployment == null) {
                throw new NoSuchDeploymentException("Managed deployment: " + name + " not found.");
            }
            ManagedDeployment managedDeployment = deployment;
            return managedDeployment;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDeploymentNames() {
        this.lockRead();
        try {
            TreeSet<String> deploymentNames = new TreeSet<String>();
            for (ProfileViewWrapper view : this.views) {
                deploymentNames.addAll(view.getDeploymentNames());
            }
            TreeSet<String> treeSet = deploymentNames;
            return treeSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDeploymentNamesForType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null deployment type");
        }
        this.lockRead();
        try {
            TreeSet<String> deployments = new TreeSet<String>();
            for (ProfileViewWrapper view : this.views) {
                deployments.addAll(view.getDeploymentNamesForType(type));
            }
            TreeSet<String> treeSet = deployments;
            return treeSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ManagedDeployment> getDeploymentsForType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null deployment type");
        }
        this.lockRead();
        try {
            HashSet<ManagedDeployment> deployments = new HashSet<ManagedDeployment>();
            for (ProfileViewWrapper view : this.views) {
                deployments.addAll(view.getDeploymentsForType(type));
            }
            HashSet<ManagedDeployment> hashSet = deployments;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type, NameMatcher<ManagedComponent> matcher) {
        if (name == null) {
            throw new IllegalArgumentException("null component name");
        }
        if (type == null) {
            throw new IllegalArgumentException("null component type");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("null component name matcher");
        }
        this.lockRead();
        try {
            HashSet<ManagedComponent> components = new HashSet<ManagedComponent>();
            for (ProfileViewWrapper view : this.views) {
                components.addAll(view.getMatchingComponents(name, type, matcher));
            }
            HashSet<ManagedComponent> hashSet = components;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMatchingDeploymentName(String regex) throws NoSuchDeploymentException {
        if (regex == null) {
            throw new IllegalArgumentException("null regex");
        }
        this.lockRead();
        try {
            TreeSet<String> deployments = new TreeSet<String>();
            for (ProfileViewWrapper view : this.views) {
                deployments.addAll(view.getMatchingDeploymentName(regex));
            }
            TreeSet<String> treeSet = deployments;
            return treeSet;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher) {
        if (name == null) {
            throw new IllegalArgumentException("null deployment name");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("null deployment matcher");
        }
        this.lockRead();
        try {
            HashSet<ManagedDeployment> deployments = new HashSet<ManagedDeployment>();
            for (ProfileViewWrapper view : this.views) {
                deployments.addAll(view.getMatchingDeployments(name, matcher));
            }
            HashSet<ManagedDeployment> hashSet = deployments;
            return hashSet;
        }
        finally {
            this.unlockRead();
        }
    }

    public DeploymentTemplateInfo getTemplate(String name) throws NoSuchDeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("null template name");
        }
        DeploymentTemplate template = this.templates.get(name);
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        DeploymentTemplateInfo info = template.getInfo();
        return info.copy();
    }

    public Set<String> getTemplateNames() {
        return new TreeSet<String>(this.templates.keySet());
    }

    public void process() throws Exception {
    }

    public void reload() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(ManagedComponent comp) throws Exception {
        if (comp == null) {
            throw new IllegalArgumentException("null managed component");
        }
        ManagedComponent serverComponent = this.getComponent(comp.getName(), comp.getType());
        if (serverComponent == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), comp.getType()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        this.lockWrite();
        try {
            ProfileViewWrapper target = this.resolveWrapper(serverComponent.getDeployment().getName());
            if (target == null) {
                throw new IllegalStateException("failed to resolve target profile for component " + serverComponent);
            }
            target.removeComponent(comp, serverComponent);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponent(ManagedComponent comp) throws Exception {
        if (comp == null) {
            throw new IllegalArgumentException("null managed component");
        }
        ManagedComponent serverComponent = this.getComponent(comp.getName(), comp.getType());
        if (serverComponent == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), comp.getType()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        this.lockWrite();
        try {
            ProfileViewWrapper target = this.resolveWrapper(serverComponent.getDeployment().getName());
            if (target == null) {
                throw new IllegalStateException("failed to resolve target profile for component " + serverComponent);
            }
            target.updateComponent(comp, serverComponent);
        }
        finally {
            this.unlockWrite();
        }
    }

    protected ProfileViewWrapper resolveWrapper(String deploymentName) {
        for (ProfileViewWrapper view : this.views) {
            if (!view.getDeploymentNames().contains(deploymentName)) continue;
            return view;
        }
        return null;
    }

    void lockRead() {
        this.lock.readLock().lock();
    }

    void unlockRead() {
        this.lock.readLock().unlock();
    }

    void lockWrite() {
        this.lock.writeLock().lock();
    }

    void unlockWrite() {
        this.lock.writeLock().unlock();
    }
}

