/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa.util;

public class ByteArrayKey {
    private int cacheH = 0;
    private byte[] bytes = null;
    private String cacheS = null;

    public ByteArrayKey(byte[] byArray) {
        this.bytes = byArray;
    }

    public ByteArrayKey(ByteArrayKey byteArrayKey) {
        this.cacheH = byteArrayKey.cacheH;
        this.cacheS = byteArrayKey.cacheS;
        this.bytes = byteArrayKey.bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        if (this.cacheH == 0) {
            long l = 1234L;
            if (this.bytes != null && this.bytes.length > 0) {
                int n = this.bytes.length;
                while (--n >= 0) {
                    l ^= (long)(this.bytes[n] * (n + 1));
                }
                this.cacheH = (int)(l >> 32 ^ l);
            }
        }
        return this.cacheH;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ByteArrayKey) {
            ByteArrayKey byteArrayKey = (ByteArrayKey)object;
            if (this.bytes == byteArrayKey.bytes || this.bytes == null && byteArrayKey.bytes == null) {
                bl = true;
            } else if (this.bytes != null && byteArrayKey.bytes != null && this.bytes.length == byteArrayKey.bytes.length) {
                bl = true;
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == byteArrayKey.bytes[i]) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    public String toString() {
        if (this.cacheS == null) {
            this.cacheS = this.bytes == null ? "" : new String(this.bytes);
        }
        return this.cacheS;
    }
}

