/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.tunnel;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.rest.tunnel.TunnelResource;
import org.apache.guacamole.rest.tunnel.TunnelResourceFactory;
import org.apache.guacamole.tunnel.UserTunnel;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TunnelCollectionResource {
    private final GuacamoleSession session;
    @Inject
    private TunnelResourceFactory tunnelResourceFactory;

    @AssistedInject
    public TunnelCollectionResource(@Assisted GuacamoleSession session) {
        this.session = session;
    }

    @GET
    public Set<String> getTunnelUUIDs() {
        return this.session.getTunnels().keySet();
    }

    @Path(value="{tunnel}")
    public TunnelResource getTunnel(@PathParam(value="tunnel") String tunnelUUID) throws GuacamoleException {
        Map tunnels = this.session.getTunnels();
        UserTunnel tunnel = (UserTunnel)tunnels.get(tunnelUUID);
        if (tunnel == null) {
            throw new GuacamoleResourceNotFoundException("No such tunnel.");
        }
        return this.tunnelResourceFactory.create(tunnel);
    }
}

