/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import org.apache.guacamole.rest.RESTExceptionMapper;
import org.apache.guacamole.rest.activeconnection.ActiveConnectionModule;
import org.apache.guacamole.rest.auth.AuthTokenGenerator;
import org.apache.guacamole.rest.auth.AuthenticationService;
import org.apache.guacamole.rest.auth.DecorationService;
import org.apache.guacamole.rest.auth.SecureRandomAuthTokenGenerator;
import org.apache.guacamole.rest.auth.TokenRESTService;
import org.apache.guacamole.rest.auth.TokenSessionMap;
import org.apache.guacamole.rest.connection.ConnectionModule;
import org.apache.guacamole.rest.connectiongroup.ConnectionGroupModule;
import org.apache.guacamole.rest.event.ListenerService;
import org.apache.guacamole.rest.extension.ExtensionRESTService;
import org.apache.guacamole.rest.language.LanguageRESTService;
import org.apache.guacamole.rest.patch.PatchRESTService;
import org.apache.guacamole.rest.session.SessionRESTService;
import org.apache.guacamole.rest.session.SessionResourceFactory;
import org.apache.guacamole.rest.session.UserContextResourceFactory;
import org.apache.guacamole.rest.sharingprofile.SharingProfileModule;
import org.apache.guacamole.rest.tunnel.TunnelCollectionResourceFactory;
import org.apache.guacamole.rest.tunnel.TunnelResourceFactory;
import org.apache.guacamole.rest.user.UserModule;
import org.apache.guacamole.rest.usergroup.UserGroupModule;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.webjars.servlet.WebjarsServlet;

public class RESTServiceModule
extends ServletModule {
    private final TokenSessionMap tokenSessionMap;

    public RESTServiceModule(TokenSessionMap tokenSessionMap) {
        this.tokenSessionMap = tokenSessionMap;
    }

    protected void configureServlets() {
        this.bind(TokenSessionMap.class).toInstance((Object)this.tokenSessionMap);
        this.bind(ListenerService.class);
        this.bind(AuthenticationService.class);
        this.bind(AuthTokenGenerator.class).to(SecureRandomAuthTokenGenerator.class);
        this.bind(DecorationService.class);
        this.bind(RESTExceptionMapper.class);
        this.bind(ExtensionRESTService.class);
        this.bind(LanguageRESTService.class);
        this.bind(PatchRESTService.class);
        this.bind(TokenRESTService.class);
        this.bind(SessionRESTService.class);
        this.install(new FactoryModuleBuilder().build(SessionResourceFactory.class));
        this.install(new FactoryModuleBuilder().build(TunnelCollectionResourceFactory.class));
        this.install(new FactoryModuleBuilder().build(TunnelResourceFactory.class));
        this.install(new FactoryModuleBuilder().build(UserContextResourceFactory.class));
        this.install((Module)new ActiveConnectionModule());
        this.install((Module)new ConnectionModule());
        this.install((Module)new ConnectionGroupModule());
        this.install((Module)new SharingProfileModule());
        this.install((Module)new UserModule());
        this.install((Module)new UserGroupModule());
        this.bind(GuiceContainer.class);
        this.bind(JacksonJsonProvider.class).in(Scopes.SINGLETON);
        this.serve("/api/*", new String[0]).with(GuiceContainer.class);
        this.bind(WebjarsServlet.class).in(Scopes.SINGLETON);
        this.serve("/webjars/*", new String[0]).with(WebjarsServlet.class);
    }
}

