/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.net;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jlibs.core.io.FileUtil;
import jlibs.core.io.IOUtil;
import jlibs.core.lang.ImpossibleException;
import jlibs.core.lang.StringUtil;

public class URLUtil {
    private static SSLContext sc;

    public static URI toURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static URL toURL(String systemID) {
        if (StringUtil.isWhitespace(systemID)) {
            return null;
        }
        systemID = systemID.trim();
        try {
            return new URL(systemID);
        }
        catch (MalformedURLException ex) {
            return FileUtil.toURL(new File(systemID));
        }
    }

    public static String toSystemID(URL url) {
        try {
            if ("file".equals(url.getProtocol())) {
                return new File(url.toURI()).getAbsolutePath();
            }
            return url.toString();
        }
        catch (URISyntaxException ex) {
            throw new ImpossibleException(ex);
        }
    }

    public static Map<String, String> getQueryParams(String uri, String encoding) throws URISyntaxException, UnsupportedEncodingException {
        if (encoding == null) {
            encoding = IOUtil.UTF_8.name();
        }
        String query = new URI(uri).getRawQuery();
        String[] params = Pattern.compile("&", 16).split(query);
        HashMap<String, String> map = new HashMap<String, String>(params.length);
        for (String param : params) {
            int equal = param.indexOf(61);
            String name = param.substring(0, equal);
            String value = param.substring(equal + 1);
            name = URLDecoder.decode(name, encoding);
            value = URLDecoder.decode(value, encoding);
            map.put(name, value);
        }
        return map;
    }

    public static String suggestFile(URI uri, String extension) {
        String path = uri.getPath();
        String[] tokens = StringUtil.getTokens(path, "/", true);
        String file = tokens[tokens.length - 1];
        int dot = file.indexOf(".");
        if (dot == -1) {
            return file + '.' + extension;
        }
        return file.substring(0, dot + 1) + extension;
    }

    public static String suggestPrefix(Properties suggested, String uri) {
        String prefix = suggested.getProperty(uri);
        if (prefix != null) {
            return prefix;
        }
        try {
            URI _uri = new URI(uri);
            String path = _uri.getPath();
            StringTokenizer stok = new StringTokenizer(path, "/");
            while (stok.hasMoreTokens()) {
                prefix = stok.nextToken();
            }
            if (prefix != null) {
                return prefix;
            }
            String host = _uri.getHost();
            if (host != null) {
                stok = new StringTokenizer(host, ".");
                String curPrefix = null;
                while (stok.hasMoreTokens()) {
                    prefix = curPrefix;
                    curPrefix = stok.nextToken();
                }
            }
            if (prefix != null) {
                return prefix;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return "ns";
    }

    public static URLConnection createUnCertifiedConnection(URL url, Proxy proxy) throws IOException {
        URLConnection con;
        if (sc == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                URLUtil.sc = sc;
            }
            catch (Exception ex) {
                throw new ImpossibleException(ex);
            }
        }
        URLConnection uRLConnection = con = proxy == null ? url.openConnection() : url.openConnection(proxy);
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            httpsCon.setSSLSocketFactory(sc.getSocketFactory());
            httpsCon.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            });
        }
        return con;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(URLUtil.getQueryParams("http://www.google.co.in/search?hl=en&client=firefox-a&rls=org.mozilla%3Aen-US%3Aofficial&hs=Jvw&q=java%26url+encode&btnG=Search&meta=&aq=f&oq=", null));
    }
}

