/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.awt.Frame;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortFactoryCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ExportFileProvider;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ModalDisplayReachedCallBack;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ProgressAbortDialog;

public class ProgressAbortFactoryCallbackImpl
implements ProgressAbortFactoryCallback {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProgressAbortFactoryCallbackImpl.class);
    private final ISession _session;
    private final String _sql;
    private final ExportFileProvider _exportFileProvider;
    private final Statement _stmt;
    private ProgressAbortCallback progressDialog;

    public ProgressAbortFactoryCallbackImpl(ISession session, String sql, ExportFileProvider exportFileProvider, Statement stmt) {
        this._session = session;
        this._sql = sql;
        this._exportFileProvider = exportFileProvider;
        this._stmt = stmt;
    }

    public ProgressAbortCallback getOrCreate() {
        return this.getOrCreate(null);
    }

    public ProgressAbortCallback getOrCreate(ModalDisplayReachedCallBack modalDisplayReachedCallBack) {
        if (null == this.progressDialog) {
            this.createProgressAbortDialog(modalDisplayReachedCallBack);
        }
        return this.progressDialog;
    }

    private void createProgressAbortDialog(ModalDisplayReachedCallBack modalDisplayReachedCallBack) {
        GUIUtils.processOnSwingEventThread(() -> this.showProgressDialog(modalDisplayReachedCallBack), (boolean)true);
    }

    private void showProgressDialog(ModalDisplayReachedCallBack modalDisplayReachedCallBack) {
        CodeReformator cr = new CodeReformator(CodeReformatorConfigFactory.createConfig((ISession)this._session));
        String reformatedSQL = cr.reformat(this._sql);
        String targetFile = this._exportFileProvider.getExportFile().getAbsolutePath();
        String title = s_stringMgr.getString("CreateFileOfCurrentSQLCommand.progress.title", new Object[]{targetFile});
        this.progressDialog = new ProgressAbortDialog((Frame)Main.getApplication().getMainFrame(), title, targetFile, reformatedSQL, 0, () -> this.onCancel(), modalDisplayReachedCallBack);
        this.progressDialog.setVisible(true);
    }

    private void onCancel() {
        if (this._stmt != null) {
            try {
                this._stmt.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void hideProgressMonitor() {
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
            this.progressDialog.dispose();
        }
    }

    public boolean isAborted() {
        return this.progressDialog != null && this.progressDialog.isStop();
    }
}

