/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.table_script;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.sqlscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.sqlscript.SQLScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.CreateDataScriptCommand;
import net.sourceforge.squirrel_sql.plugins.sqlscript.table_script.ScriptUtil;

public class CreateDataScriptOfCurrentSQLCommand
extends CreateDataScriptCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreateDataScriptOfCurrentSQLCommand.class);
    private final SQLScriptPlugin _plugin;

    public CreateDataScriptOfCurrentSQLCommand(ISession session, SQLScriptPlugin plugin) {
        super(session, plugin, false);
        this._plugin = plugin;
    }

    @Override
    public void execute() {
        this._session.getApplication().getThreadPool().addTask(() -> this.doCreateDataScript());
        this.showAbortFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateDataScript() {
        IQueryTokenizer qt;
        StringBuffer sbRows;
        block11: {
            sbRows = new StringBuffer(1000);
            ISQLPanelAPI api = FrameWorkAcessor.getSQLPanelAPI(this._session, this._plugin);
            String scripts = api.getSQLScriptToBeExecuted();
            qt = this._session.getQueryTokenizer();
            qt.setScriptToTokenize(scripts);
            if (qt.hasQuery()) break block11;
            this._session.showErrorMessage(s_stringMgr.getString("CreateTableOfCurrentSQLCommand.noQuery"));
            SwingUtilities.invokeLater(new Runnable(sbRows){
                final /* synthetic */ StringBuffer val$sbRows;
                {
                    this.val$sbRows = stringBuffer;
                }

                @Override
                public void run() {
                    if (this.val$sbRows.length() > 0) {
                        FrameWorkAcessor.getSQLPanelAPI(CreateDataScriptOfCurrentSQLCommand.this._session, CreateDataScriptOfCurrentSQLCommand.this._plugin).appendSQLScript(this.val$sbRows.toString(), true);
                        if (!(CreateDataScriptOfCurrentSQLCommand.this._session.getSelectedMainTab() instanceof BaseSQLTab)) {
                            CreateDataScriptOfCurrentSQLCommand.this._session.selectMainTab(1);
                        }
                    }
                    CreateDataScriptOfCurrentSQLCommand.this.hideAbortFrame();
                }
            });
            return;
        }
        try {
            ISQLConnection conn = this._session.getSQLConnection();
            while (qt.hasQuery()) {
                Statement stmt = conn.createStatement();
                try {
                    String sql = qt.nextQuery().getQuery();
                    ResultSet srcResult = stmt.executeQuery(sql);
                    String tableName = this.getFirstTableNameFromResultSetMetaData(srcResult);
                    if (StringUtilities.isEmpty((String)tableName, (boolean)true)) {
                        tableName = new EditableSqlCheck(sql).getTableNameFromSQL();
                    }
                    if (StringUtilities.isEmpty((String)tableName, (boolean)true)) {
                        tableName = "PressCtrlH";
                    }
                    this.genInserts(srcResult, tableName, sbRows, false);
                }
                finally {
                    SQLUtilities.closeStatement((Statement)stmt);
                }
            }
        }
        catch (Exception e) {
            try {
                this._session.showErrorMessage((Throwable)e);
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private String getFirstTableNameFromResultSetMetaData(ResultSet srcResult) throws SQLException {
        ResultSetMetaData metaData = srcResult.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            TableInfo tInfo = new TableInfo(metaData.getCatalogName(i), metaData.getSchemaName(i), metaData.getTableName(i), "TABLE", "", this._session.getMetaData());
            String tableName = ScriptUtil.getTableName((ITableInfo)tInfo);
            if (StringUtilities.isEmpty((String)tableName, (boolean)true)) continue;
            return tableName;
        }
        return null;
    }
}

