/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.tokenizer;

import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ITokenizerFactory;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MSSQLQueryTokenizer
extends QueryTokenizer
implements IQueryTokenizer {
    private static final ILogger s_log = LoggerController.createLogger(MSSQLQueryTokenizer.class);
    private IQueryTokenizerPreferenceBean _prefs = null;

    public MSSQLQueryTokenizer(IQueryTokenizerPreferenceBean prefs) {
        super(prefs);
        this._prefs = prefs;
    }

    public void setScriptToTokenize(String script) {
        super.setScriptToTokenize(script);
        this._queryIterator = this._queries.iterator();
    }

    protected void setFactory() {
        this._tokenizerFactory = new ITokenizerFactory(){

            public IQueryTokenizer getTokenizer() {
                return new MSSQLQueryTokenizer(MSSQLQueryTokenizer.this._prefs);
            }
        };
    }

    public TokenizerSessPropsInteractions getTokenizerSessPropsInteractions() {
        if (this._prefs.isInstallCustomQueryTokenizer()) {
            TokenizerSessPropsInteractions ret = new TokenizerSessPropsInteractions();
            ret.setTokenizerDefinesRemoveMultiLineComment(true);
            ret.setTokenizerDefinesStartOfLineComment(true);
            ret.setTokenizerDefinesStatementSeparator(true);
            return ret;
        }
        return super.getTokenizerSessPropsInteractions();
    }
}

