/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.exp;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MssqlTableTriggerExtractorImpl
implements ITableTriggerExtractor {
    private static final ILogger s_log = LoggerController.createLogger(MssqlTableTriggerExtractorImpl.class);
    private static String SQL = "SELECT     sys.triggers.name AS [trigger] FROM       sys.schemas JOIN sys.tables ON sys.schemas.schema_id = sys.tables.schema_id JOIN sys.triggers ON sys.tables.object_id = sys.triggers.parent_id WHERE sys.tables.name = ? AND sys.schemas.name = ?";

    public void bindParamters(PreparedStatement pstmt, IDatabaseObjectInfo dbo) throws SQLException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Binding table name " + dbo.getSimpleName() + " as first bind value"));
            s_log.debug((Object)("Binding schema name " + dbo.getSchemaName() + " as second bind value"));
        }
        pstmt.setString(1, dbo.getSimpleName());
        pstmt.setString(2, dbo.getSchemaName());
    }

    public String getTableTriggerQuery() {
        return SQL;
    }
}

