/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.action;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.WrappedSQLException;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mssql.util.MssqlIntrospector;

public class ScriptProcedureCommand
implements ICommand {
    private ISession _session;
    private final MssqlPlugin _plugin;
    private final IDatabaseObjectInfo[] _dbObjs;

    public ScriptProcedureCommand(ISession session, MssqlPlugin plugin, IDatabaseObjectInfo[] dbObjs) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (dbObjs == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo array is null");
        }
        this._session = session;
        this._plugin = plugin;
        this._dbObjs = dbObjs;
    }

    public void execute() throws BaseException {
        try {
            if (this._dbObjs.length > 0) {
                Connection conn = this._session.getSQLConnection().getConnection();
                String sqlSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < this._dbObjs.length; ++i) {
                    IDatabaseObjectInfo ti = this._dbObjs[i];
                    if (!conn.getCatalog().equals(ti.getCatalogName())) {
                        conn.setCatalog(ti.getCatalogName());
                    }
                    buf.append(MssqlIntrospector.getHelpTextForObject(MssqlIntrospector.getFixedVersionedObjectName(ti.getSimpleName()), conn));
                    buf.append("\n");
                    buf.append(sqlSep);
                    buf.append("\n\n");
                }
                this._session.getSessionInternalFrame().getMainSQLPanelAPI().appendSQLScript(buf.toString());
                this._session.selectMainTab(1);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new WrappedSQLException(ex);
        }
    }
}

