/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.gui.DataSetViewerTableCopyAction;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.MakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowReferencesCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowRowNumbersCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyAlignedCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyAsMarkdownCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyColumnHeaderCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyHtmlCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInsertStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyUpdateStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyWhereStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableSelectAllCellsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableSelectEntireRowsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.UndoMakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.ColorSelectedRowsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.CopyColoredRowsToNewWindowCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.GotoColorMenuController;
import net.sourceforge.squirrel_sql.fw.gui.action.copyseparatedby.TableCopySeparatedByCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.CopySelectedRowsToOwnWindowCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.CopyWikiTableActionFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.ICopyWikiTableActionFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class TablePopupMenu
extends BasePopupMenu {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TablePopupMenu.class);
    private ISession _session;
    private JCheckBoxMenuItem _alwaysAdjustAllColWidtshActionItem;
    private JCheckBoxMenuItem _showRowNumbersItem;
    private DataSetViewerTableCopyAction _copy;
    private CopyWithHeadersAction _copyWithHeaders = new CopyWithHeadersAction();
    private CopyHtmlAction _copyHtml = new CopyHtmlAction();
    private CopyAlignedAction _copyAligned = new CopyAlignedAction();
    private CopyAsMarkdownAction _copyAsMarkdown = new CopyAsMarkdownAction();
    private CopySeparatedByAction _copySeparatedBy = new CopySeparatedByAction();
    private CopyInStatementAction _copyInStatement = new CopyInStatementAction();
    private CopyWhereStatementAction _copyWhereStatement = new CopyWhereStatementAction();
    private CopyUpdateStatementAction _copyUpdateStatement = new CopyUpdateStatementAction();
    private CopyInsertStatementAction _copyInsertStatement = new CopyInsertStatementAction();
    private CopyColumnHeaderAction _copyColumnHeader = new CopyColumnHeaderAction();
    private ShowReferencesAction _showReferences = new ShowReferencesAction();
    private CopySelectedRowsToOwnWindowAction _copySelectedRowsToOwnWindow = new CopySelectedRowsToOwnWindowAction();
    private ColorSelectedRowsAction _colorSelectedRows = new ColorSelectedRowsAction();
    private GotoColorMenuController _gotoColorMenuController = new GotoColorMenuController();
    private CopyColoredRowsToNewWindowAction _copyColoredRowsToNewWindow = new CopyColoredRowsToNewWindowAction();
    private ExportCsvAction _exportCvs = new ExportCsvAction();
    private AdjustAllColWidthsAction _adjustAllColWidthsAction = new AdjustAllColWidthsAction();
    private AlwaysAdjustAllColWidthsAction _alwaysAdjustAllColWidthsAction = new AlwaysAdjustAllColWidthsAction();
    private ShowRowNumbersAction _showRowNumbersAction = new ShowRowNumbersAction();
    private MakeEditableAction _makeEditable = new MakeEditableAction();
    private UndoMakeEditableAction _undoMakeEditable = new UndoMakeEditableAction();
    private DeleteRowsAction _deleteRows = new DeleteRowsAction();
    private InsertRowAction _insertRow = new InsertRowAction();
    private SelectAllAction _select = new SelectAllAction();
    private SelectRowsAction _selectRows = new SelectRowsAction();
    private PrintAction _print = new PrintAction();
    private IDataSetUpdateableModel _updateableModel = null;
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private ICopyWikiTableActionFactory copyWikiTableActionFactory = CopyWikiTableActionFactory.getInstance();

    public TablePopupMenu(boolean allowEditing, IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel dataSetViewerTable, ISession session) {
        this._updateableModel = updateableModel;
        this._dataSetViewerTablePanel = dataSetViewerTable;
        this._session = session;
        this._copy = new DataSetViewerTableCopyAction(dataSetViewerTable.getTable());
        this.addAction(this._copy, DataSetViewerTableCopyAction.getTableCopyActionKeyStroke());
        this.addAction(this._copyWithHeaders);
        this.addAction(this._copyHtml);
        this.addAction(this._copyAligned);
        this.addAction(this._copyAsMarkdown);
        this.addAction(this._copySeparatedBy);
        this.add(this.copyWikiTableActionFactory.createMenueItem(() -> this._dataSetViewerTablePanel.getTable()));
        this.addAction(this._copyInStatement);
        this.addAction(this._copyWhereStatement);
        this.addAction(this._copyUpdateStatement);
        this.addAction(this._copyInsertStatement);
        this.addAction(this._copyColumnHeader);
        if (null != this._session) {
            this.addSeparator();
            this.addAction(this._showReferences);
        }
        this.addSeparator();
        this.addAction(this._copySelectedRowsToOwnWindow);
        this.addSeparator();
        this.addAction(this._colorSelectedRows);
        this.add(this._gotoColorMenuController.getParentMenu());
        this.add(this._copyColoredRowsToNewWindow);
        this.addSeparator();
        this.addAction(this._exportCvs);
        this.addSeparator();
        this.addAction(this._adjustAllColWidthsAction);
        this._alwaysAdjustAllColWidtshActionItem = new JCheckBoxMenuItem();
        this._alwaysAdjustAllColWidtshActionItem.setSelected(ButtonTableHeader.isAlwaysAdjustAllColWidths());
        this._alwaysAdjustAllColWidtshActionItem.setAction(this._alwaysAdjustAllColWidthsAction);
        this.addMenuItem(this._alwaysAdjustAllColWidtshActionItem);
        this.addSeparator();
        this._showRowNumbersItem = new JCheckBoxMenuItem();
        this._showRowNumbersItem.setSelected(false);
        this._showRowNumbersItem.setAction(this._showRowNumbersAction);
        this.addMenuItem(this._showRowNumbersItem);
        if (allowEditing) {
            this.addSeparator();
            this.addAction(this._makeEditable);
        }
        if (updateableModel != null && updateableModel.editModeIsForced()) {
            this.addAction(this._undoMakeEditable);
        }
        this.addSeparator();
        this.addAction(this._select);
        this.addAction(this._selectRows);
        if (this._updateableModel != null && !allowEditing) {
            this.addSeparator();
            this.addAction(this._insertRow);
            this.addAction(this._deleteRows);
        }
        this.addSeparator();
        this.addAction(this._print);
    }

    private void addMenuItem(final JMenuItem menuItem) {
        String actionName = menuItem.getText();
        KeyStroke validKeyStroke = Main.getApplication().getShortcutManager().setAccelerator(menuItem, null, actionName);
        this.add(menuItem);
        if (null != validKeyStroke) {
            DataSetViewerTable table = this._dataSetViewerTablePanel.getTable();
            table.getInputMap(1).put(validKeyStroke, actionName);
            table.getInputMap(2).put(validKeyStroke, actionName);
            table.getInputMap(0).put(validKeyStroke, actionName);
            table.getActionMap().put(actionName, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menuItem.doClick();
                }
            });
        }
    }

    private void addAction(Action action) {
        this.addAction(action, null);
    }

    private void addAction(Action action, KeyStroke defaultKeyStroke) {
        KeyStroke validKeyStroke = Main.getApplication().getShortcutManager().setAccelerator(this.add(action), defaultKeyStroke, action);
        if (null != validKeyStroke) {
            DataSetViewerTable table = this._dataSetViewerTablePanel.getTable();
            table.getInputMap(1).put(validKeyStroke, action.getClass().getName());
            table.getInputMap(2).put(validKeyStroke, action.getClass().getName());
            table.getInputMap(0).put(validKeyStroke, action.getClass().getName());
            table.getActionMap().put(action.getClass().getName(), action);
        }
    }

    public TablePopupMenu(IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel dataSetViewerTablePanel, DataSetViewerTable table) {
        this._updateableModel = updateableModel;
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this.add(this._select);
        this.addSeparator();
        this.add(this._insertRow);
        this.add(this._deleteRows);
        this.addSeparator();
        this.add(this._print);
    }

    public void reset() {
        this._showRowNumbersItem.setSelected(false);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this._gotoColorMenuController.createSubMenus(this._dataSetViewerTablePanel.getTable());
        super.show(invoker, x, y);
    }

    @Override
    public void show(MouseEvent evt) {
        super.show(evt);
    }

    public void ensureRowNumbersMenuItemIsUpToDate(boolean currentState) {
        if (currentState == this._showRowNumbersItem.isSelected()) {
            return;
        }
        this._showRowNumbersItem.setAction(null);
        this._showRowNumbersItem.setSelected(currentState);
        this._showRowNumbersItem.setAction(this._showRowNumbersAction);
    }

    private class PrintAction
    extends BaseAction {
        PrintAction() {
            super(s_stringMgr.getString("TablePopupMenu.print"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(TablePopupMenu.this._dataSetViewerTablePanel);
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class SelectRowsAction
    extends BaseAction {
        SelectRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.selectEntireRows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableSelectEntireRowsCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class SelectAllAction
    extends BaseAction {
        SelectAllAction() {
            super(s_stringMgr.getString("TablePopupMenu.selectall"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableSelectAllCellsCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class InsertRowAction
    extends BaseAction {
        InsertRowAction() {
            super(s_stringMgr.getString("TablePopupMenu.insertrow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TablePopupMenu.this._dataSetViewerTablePanel.insertRow();
        }
    }

    private class DeleteRowsAction
    extends BaseAction {
        DeleteRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.deleterows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int[] selectedRows = TablePopupMenu.this._dataSetViewerTablePanel.getTable().getSelectedRows();
            TablePopupMenu.this._dataSetViewerTablePanel.deleteRows(selectedRows);
        }
    }

    private class UndoMakeEditableAction
    extends BaseAction {
        UndoMakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.undomakeeditable"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new UndoMakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class MakeEditableAction
    extends BaseAction {
        MakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.makeeditable"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new MakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class ShowRowNumbersAction
    extends BaseAction {
        ShowRowNumbersAction() {
            super(s_stringMgr.getString("TablePopupMenu.showRowNumbers"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem mnu = (JCheckBoxMenuItem)evt.getSource();
            new ShowRowNumbersCommand(TablePopupMenu.this._dataSetViewerTablePanel, mnu.isSelected()).execute();
        }
    }

    private class AlwaysAdjustAllColWidthsAction
    extends BaseAction {
        AlwaysAdjustAllColWidthsAction() {
            super(s_stringMgr.getString("TablePopupMenu.alwaysAdoptAllColWiths"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ButtonTableHeader.setAlwaysAdjustAllColWidths(TablePopupMenu.this._alwaysAdjustAllColWidtshActionItem.isSelected());
            if (TablePopupMenu.this._alwaysAdjustAllColWidtshActionItem.isSelected()) {
                TablePopupMenu.this._dataSetViewerTablePanel.getTable().getButtonTableHeader().adjustAllColWidths(true);
            }
        }
    }

    private class AdjustAllColWidthsAction
    extends BaseAction {
        AdjustAllColWidthsAction() {
            super(s_stringMgr.getString("TablePopupMenu.adoptAllColWidthsAction"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._dataSetViewerTablePanel.getTable().getTableHeader() instanceof ButtonTableHeader) {
                TablePopupMenu.this._dataSetViewerTablePanel.getTable().getButtonTableHeader().adjustAllColWidths(true);
            }
        }
    }

    private class CopyColoredRowsToNewWindowAction
    extends BaseAction {
        CopyColoredRowsToNewWindowAction() {
            super(s_stringMgr.getString("TablePopupMenu.CopyColoredRowsToNewWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new CopyColoredRowsToNewWindowCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._session).execute();
        }
    }

    private class ColorSelectedRowsAction
    extends BaseAction {
        ColorSelectedRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.ColorSelectedRows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new ColorSelectedRowsCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class CopySelectedRowsToOwnWindowAction
    extends BaseAction {
        CopySelectedRowsToOwnWindowAction() {
            super(s_stringMgr.getString("TablePopupMenu.CopySelectedRowsToOwnWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new CopySelectedRowsToOwnWindowCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._session).execute();
        }
    }

    private class ShowReferencesAction
    extends BaseAction {
        ShowReferencesAction() {
            super(s_stringMgr.getString("TablePopupMenu.showRefernces"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new ShowReferencesCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._updateableModel, (JFrame)GUIUtils.getOwningFrame(TablePopupMenu.this._dataSetViewerTablePanel.getTable()), TablePopupMenu.this._session).execute();
        }
    }

    private class ExportCsvAction
    extends BaseAction {
        ExportCsvAction() {
            super(s_stringMgr.getString("TablePopupMenu.export"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                new TableExportCsvCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute(SwingUtilities.windowForComponent(TablePopupMenu.this._dataSetViewerTablePanel.getTable()));
            }
            catch (ExportDataException e) {
                throw Utilities.wrapRuntime(e);
            }
        }
    }

    private class CopyColumnHeaderAction
    extends BaseAction {
        CopyColumnHeaderAction() {
            super(s_stringMgr.getString("TablePopupMenu.copycolumnheader"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyColumnHeaderCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class CopyInsertStatementAction
    extends BaseAction {
        CopyInsertStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasinsertstatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyInsertStatementCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._dataSetViewerTablePanel.getDataModelImplementationDetails()).execute();
        }
    }

    private class CopyUpdateStatementAction
    extends BaseAction {
        CopyUpdateStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasupdatestatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyUpdateStatementCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._dataSetViewerTablePanel.getDataModelImplementationDetails()).execute();
        }
    }

    private class CopyWhereStatementAction
    extends BaseAction {
        CopyWhereStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyaswherestatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyWhereStatementCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class CopyInStatementAction
    extends BaseAction {
        CopyInStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasinstatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyInStatementCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class CopySeparatedByAction
    extends BaseAction {
        CopySeparatedByAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyseparatedby"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopySeparatedByCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class CopyAsMarkdownAction
    extends BaseAction {
        CopyAsMarkdownAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasmarkdown"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyAsMarkdownCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._session).execute();
        }
    }

    private class CopyAlignedAction
    extends BaseAction {
        CopyAlignedAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyaligned"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyAlignedCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), TablePopupMenu.this._session).execute();
        }
    }

    private class CopyHtmlAction
    extends BaseAction {
        CopyHtmlAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyashtml"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyHtmlCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable()).execute();
        }
    }

    private class CopyWithHeadersAction
    extends BaseAction {
        CopyWithHeadersAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyWithHeaders"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new TableCopyCommand(TablePopupMenu.this._dataSetViewerTablePanel.getTable(), true).execute();
        }
    }
}

