/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;

public class FontFamilyWrapper {
    private Boolean _monospaced = null;
    private String _fontFamilyName;

    public FontFamilyWrapper(String fontFamilyName) {
        this._fontFamilyName = fontFamilyName;
    }

    public FontFamilyWrapper(String fontFamilyName, boolean monospaced) {
        this._fontFamilyName = fontFamilyName;
        this._monospaced = monospaced;
    }

    public String getFontFamilyName() {
        return this._fontFamilyName;
    }

    public String toString() {
        if (null == this._monospaced) {
            return this._fontFamilyName;
        }
        if (this._monospaced.booleanValue()) {
            return this._fontFamilyName + " (monospaced)";
        }
        return this._fontFamilyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontFamilyWrapper wrapper = (FontFamilyWrapper)o;
        return this._fontFamilyName != null ? this._fontFamilyName.equals(wrapper._fontFamilyName) : wrapper._fontFamilyName == null;
    }

    public int hashCode() {
        return this._fontFamilyName != null ? this._fontFamilyName.hashCode() : 0;
    }

    public static FontFamilyWrapper[] createWrappers(Component comp) {
        String[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        FontFamilyWrapper[] ret = new FontFamilyWrapper[availableFontFamilyNames.length];
        for (int i = 0; i < availableFontFamilyNames.length; ++i) {
            FontFamilyWrapper wrapper;
            String availableFontFamilyName = availableFontFamilyNames[i];
            ret[i] = wrapper = FontFamilyWrapper.wrap(comp, availableFontFamilyName);
        }
        return ret;
    }

    public static FontFamilyWrapper wrap(Component comp, String availableFontFamilyName) {
        FontFamilyWrapper wrapper;
        Font font = Font.decode(availableFontFamilyName);
        if (null == font) {
            wrapper = new FontFamilyWrapper(availableFontFamilyName);
        } else {
            FontMetrics fm = comp.getFontMetrics(font);
            if (null != fm) {
                boolean isMonoSpaced = fm.stringWidth("m") == fm.stringWidth("i");
                wrapper = new FontFamilyWrapper(availableFontFamilyName, isMonoSpaced);
            } else {
                wrapper = new FontFamilyWrapper(availableFontFamilyName);
            }
        }
        return wrapper;
    }
}

