/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.util.HashMap;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.RowWrapper;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DuplicateConsecutiveRowsHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Integer, Color> _colorByViewRow;

    public DuplicateConsecutiveRowsHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._colorByViewRow = null;
                return;
            }
            this._colorByViewRow = new HashMap();
            DataSetViewerTableModel dataSetViewerTableModel = this._dataSetViewerTable.getDataSetViewerTableModel();
            if (dataSetViewerTableModel.getRowCount() < 2) {
                return;
            }
            TreeMap<Integer, Integer> modelIndexByViewIndex = this.createModelIndexByViewIndexTreeMap(dataSetViewerTableModel);
            Color curColor = SquirrelConstants.DUPLICATE_COLOR;
            int lastColoredViewRow = -100;
            for (int viewIx = 1; viewIx < modelIndexByViewIndex.size(); ++viewIx) {
                RowWrapper thisRow;
                RowWrapper formerRow = new RowWrapper(dataSetViewerTableModel, modelIndexByViewIndex.get(viewIx - 1));
                if (Utilities.equalsRespectNull(formerRow, thisRow = new RowWrapper(dataSetViewerTableModel, modelIndexByViewIndex.get(viewIx)))) {
                    this._colorByViewRow.put(viewIx - 1, curColor);
                    this._colorByViewRow.put(viewIx, curColor);
                    lastColoredViewRow = viewIx;
                    continue;
                }
                if (lastColoredViewRow != viewIx - 1) continue;
                curColor = SquirrelConstants.DUPLICATE_COLOR == curColor ? SquirrelConstants.DUPLICATE_COLOR_DARKER : SquirrelConstants.DUPLICATE_COLOR;
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    private TreeMap<Integer, Integer> createModelIndexByViewIndexTreeMap(DataSetViewerTableModel dataSetViewerTableModel) {
        TreeMap<Integer, Integer> modelIndexByViewIndex = new TreeMap<Integer, Integer>();
        SortableTableModel sortableTableModel = this._dataSetViewerTable.getSortableTableModel();
        for (int viewIx = 0; viewIx < dataSetViewerTableModel.getRowCount(); ++viewIx) {
            modelIndexByViewIndex.put(viewIx, sortableTableModel.transformToModelRow(viewIx));
        }
        return modelIndexByViewIndex;
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_ROWS;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._colorByViewRow) {
            return null;
        }
        return this._colorByViewRow.get(row);
    }
}

