/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.shortcut;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.shortcut.Shortcut;
import net.sourceforge.squirrel_sql.client.shortcut.ShortcutsJsonBean;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ShortcutManager {
    private HashSet<Shortcut> _shortcuts = new HashSet();
    private ShortcutsJsonBean _shortcutsJsonBeanLoadedAtStartUp;

    public ShortcutManager() {
        try {
            File shortCutsJsonBeanFile = new ApplicationFiles().getShortCutsJsonBeanFile();
            if (!shortCutsJsonBeanFile.exists()) {
                this._shortcutsJsonBeanLoadedAtStartUp = new ShortcutsJsonBean();
                return;
            }
            FileInputStream is = new FileInputStream(shortCutsJsonBeanFile);
            InputStreamReader isr = new InputStreamReader((InputStream)is, JsonEncoding.UTF8.getJavaName());
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this._shortcutsJsonBeanLoadedAtStartUp = (ShortcutsJsonBean)mapper.readValue((Reader)isr, (JavaType)SimpleType.construct(ShortcutsJsonBean.class));
            isr.close();
            is.close();
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public List<Shortcut> getShortcuts() {
        return new ArrayList<Shortcut>(this._shortcuts);
    }

    public KeyStroke setAccelerator(JMenuItem item, KeyStroke defaultKeyStroke, Action action) {
        return this.setAccelerator(item, defaultKeyStroke, (String)action.getValue("Name"));
    }

    public KeyStroke setAccelerator(JMenuItem item, KeyStroke defaultKeyStroke, String actionName) {
        Shortcut shortcut = this._registerAccelerator(actionName, defaultKeyStroke);
        item.setAccelerator(shortcut.validKeyStroke());
        return KeyStroke.getKeyStroke(shortcut.getValidKeyStroke());
    }

    public void registerAccelerator(Class<? extends Action> actionClass) {
        this.registerAccelerator(actionClass, Main.getApplication().getResources());
    }

    public String registerAccelerator(Class<? extends Action> actionClass, Resources pluginResources) {
        String actionName = pluginResources.getActionName(actionClass);
        KeyStroke defaultKeyStroke = pluginResources.getShortCutReader().getDefaultShortcutAsKeyStroke(pluginResources.getFullMenuItemKey(actionClass), actionName);
        return this._registerAccelerator(actionName, defaultKeyStroke).getValidKeyStroke();
    }

    public String registerAccelerator(String actionName, KeyStroke defaultKeyStroke) {
        return this._registerAccelerator(actionName, defaultKeyStroke).getValidKeyStroke();
    }

    private Shortcut _registerAccelerator(String actionName, KeyStroke defaultKeyStroke) {
        if (StringUtilities.isEmpty(actionName, true)) {
            return new Shortcut(actionName, defaultKeyStroke);
        }
        Shortcut ret = new Shortcut(actionName, defaultKeyStroke);
        String userShortCutString = this._shortcutsJsonBeanLoadedAtStartUp.getShortcutByKey().get(ret.generateKey());
        if (null != userShortCutString) {
            ret.setUserKeyStroke(KeyStroke.getKeyStroke(userShortCutString));
        } else if (this._shortcutsJsonBeanLoadedAtStartUp.getShortcutByKey().containsKey(ret.generateKey())) {
            ret.setUserKeyStrokeEmpty();
        }
        if (!this._shortcuts.contains(ret)) {
            this._shortcuts.add(ret);
        }
        return ret;
    }

    public void save() {
        try {
            ShortcutsJsonBean bean = new ShortcutsJsonBean();
            for (Shortcut shortcut : this._shortcuts) {
                if (!shortcut.hasUserKeyStroke()) continue;
                bean.getShortcutByKey().put(shortcut.generateKey(), shortcut.generateUserKeyStrokeString());
            }
            File shortCutsJsonBeanFile = new ApplicationFiles().getShortCutsJsonBeanFile();
            FileOutputStream fos = new FileOutputStream(shortCutsJsonBeanFile);
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter objectWriter = mapper.writerWithDefaultPrettyPrinter();
            objectWriter.writeValue((OutputStream)fos, (Object)bean);
            fos.close();
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

