/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public enum TimeScale {
    MILLISECONDS("TimeScale.milliSeconds", 1.0),
    SECONDS("TimeScale.seconds", 1000.0),
    MINUTES("TimeScale.minutes", 60000.0),
    HOURS("TimeScale.hours", 3600000.0),
    DAYS("TimeScale.days", 8.64E7),
    WEEKS("TimeScale.weeks", 6.048E8),
    YEARS("TimeScale.years", 1.471228928E9);

    private static final StringManager s_stringMgr;
    private String _i18nString;
    private double _scale;

    private TimeScale(String i18nString, double scale) {
        this._i18nString = i18nString;
        this._scale = scale;
    }

    public String toString() {
        return s_stringMgr.getString(this._i18nString);
    }

    public double scale(double value) {
        return value / this._scale;
    }

    static {
        s_stringMgr = StringManagerFactory.getStringManager(TimeScale.class);
    }
}

