/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs;

import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseObjectTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetScrollingPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MapDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BasePreparedStatementTab
extends BaseObjectTab {
    private final String _title;
    private final String _hint;
    private boolean _firstRowOnly;
    private DataSetScrollingPanel _comp;
    private static final ILogger s_log = LoggerController.createLogger(BasePreparedStatementTab.class);

    public BasePreparedStatementTab(String title, String hint) {
        this(title, hint, false);
    }

    public BasePreparedStatementTab(String title, String hint, boolean firstRowOnly) {
        if (title == null) {
            throw new IllegalArgumentException("Title == null");
        }
        this._title = title;
        this._hint = hint != null ? hint : title;
        this._firstRowOnly = firstRowOnly;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getHint() {
        return this._hint;
    }

    @Override
    public void clear() {
    }

    @Override
    public Component getComponent() {
        if (this._comp == null) {
            ISession session = this.getSession();
            SessionProperties props = session.getProperties();
            String destClassName = props.getMetaDataOutputClassName();
            try {
                this._comp = new DataSetScrollingPanel(destClassName, null, new DataModelImplementationDetails(session), session);
            }
            catch (Exception e) {
                s_log.error("Unexpected exception from call to getComponent: " + e.getMessage(), e);
            }
        }
        return this._comp;
    }

    @Override
    protected void refreshComponent() throws DataSetException {
        if (this.getDatabaseObjectInfo().getDatabaseObjectType().isContainerNode()) {
            this._comp.clear();
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.createStatement();
            rs = pstmt.executeQuery();
            IDataSet ds = this.createDataSetFromResultSet(rs);
            this._comp.load(ds, new DataModelImplementationDetails(this.getSession()));
        }
        catch (SQLException ex) {
            try {
                throw new DataSetException(ex);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs, true);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs, true);
    }

    protected abstract PreparedStatement createStatement() throws SQLException;

    protected IDataSet createDataSetFromResultSet(ResultSet rs) throws DataSetException {
        ResultSetDataSet rsds = new ResultSetDataSet();
        rsds.setResultSet(rs, this.getDialectType());
        if (!this._firstRowOnly) {
            return rsds;
        }
        int columnCount = rsds.getColumnCount();
        ColumnDisplayDefinition[] colDefs = rsds.getDataSetDefinition().getColumnDefinitions();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (rsds.next(null)) {
            for (int i = 0; i < columnCount; ++i) {
                data.put(colDefs[i].getColumnName(), rsds.get(i));
            }
        }
        return new MapDataSet(data);
    }
}

