/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Frame;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;

public class SessionUtils {
    public static Frame getOwningFrame(ISession destSession) {
        Frame owningFrame = destSession.getActiveSessionWindow().hasSQLPanelAPI() ? GUIUtils.getOwningFrame(destSession.getSQLPanelAPIOfActiveSessionWindow().getSQLEntryPanel().getTextComponent()) : GUIUtils.getOwningFrame(destSession.getObjectTreeAPIOfActiveSessionWindow().getDetailTabComp());
        return owningFrame;
    }

    public static Frame getOwningFrame(ISQLPanelAPI sqlPanelAPI) {
        return GUIUtils.getOwningFrame(sqlPanelAPI.getSQLEntryPanel().getTextComponent());
    }

    static ISQLPanelAPI getSqlPanelApi(IIdentifier entryPanelIdentifier, IIdentifier sessionIdentifier) {
        ISessionWidget[] frames = Main.getApplication().getWindowManager().getAllFramesOfSession(sessionIdentifier);
        for (int i = 0; i < frames.length; ++i) {
            IObjectTreeAPI objectTreeApi;
            IIdentifier findEditorID;
            ISQLPanelAPI sqlPanelAPI;
            IIdentifier id;
            if (frames[i] instanceof SQLInternalFrame && (id = (sqlPanelAPI = ((SQLInternalFrame)frames[i]).getMainSQLPanelAPI()).getSQLEntryPanel().getIdentifier()).equals(entryPanelIdentifier)) {
                return sqlPanelAPI;
            }
            if (frames[i] instanceof SessionInternalFrame) {
                ISQLPanelAPI sqlPanelAPI2 = ((SessionInternalFrame)frames[i]).getMainSQLPanelAPI();
                IIdentifier sqlEditorID = sqlPanelAPI2.getSQLEntryPanel().getIdentifier();
                if (sqlEditorID.equals(entryPanelIdentifier)) {
                    return sqlPanelAPI2;
                }
                IObjectTreeAPI objectTreeApi2 = ((SessionInternalFrame)frames[i]).getObjectTreeAPI();
                IIdentifier findEditorID2 = objectTreeApi2.getFindController().getFindEntryPanel().getIdentifier();
                SessionPanel sessionPanel = ((SessionInternalFrame)frames[i]).getSessionPanel();
                for (int j = 0; j < sessionPanel.getTabCount(); ++j) {
                    if (!(sessionPanel.getMainPanelTabAt(j) instanceof AdditionalSQLTab) || !(sqlEditorID = (sqlPanelAPI2 = ((AdditionalSQLTab)sessionPanel.getMainPanelTabAt(j)).getSQLPanel().getSQLPanelAPI()).getSQLEntryPanel().getIdentifier()).equals(entryPanelIdentifier)) continue;
                    return sqlPanelAPI2;
                }
                if (findEditorID2.equals(entryPanelIdentifier)) {
                    return null;
                }
            }
            if (!(frames[i] instanceof ObjectTreeInternalFrame) || !(findEditorID = (objectTreeApi = ((ObjectTreeInternalFrame)frames[i]).getObjectTreeAPI()).getFindController().getFindEntryPanel().getIdentifier()).equals(entryPanelIdentifier)) continue;
            return null;
        }
        throw new IllegalStateException("Session has no entry panel for ID=" + entryPanelIdentifier);
    }

    public static IMainPanelTab getOwningIMainPanelTab(IFileEditorAPI fileEditorAPI) {
        SessionPanel sessionSheet = fileEditorAPI.getSession().getSessionPanel();
        for (int i = 0; i < sessionSheet.getTabCount(); ++i) {
            IMainPanelTab mainPanelTab = sessionSheet.getMainPanelTabAt(i);
            if (mainPanelTab.getActiveFileEditorAPIOrNull() != fileEditorAPI) continue;
            return mainPanelTab;
        }
        return null;
    }
}

